# przykad 3.16 z punktu 3.2.2 
# (przykad 3.16 z punktu 3.2.2)  : Eksploracja danych : Wykrywanie problemw za pomoc statystyk podsumowujcych : Wizualne sprawdzanie relacji pomidzy dwiema zmiennymi 
# Tytu: Tworzenie wykresw supkowych zawierajcych fasety i pozbawionych faset 

cdata <- subset(customer_data, !is.na(housing_type))            	# Uwaga 1. 

ggplot(cdata, aes(x=housing_type, fill=marital_status)) + 	# Uwaga 2. 
  geom_bar(position = "dodge") + 
  scale_fill_brewer(palette = "Dark2") + 
  coord_flip()                                            	# Uwaga 3. 

ggplot(cdata, aes(x=marital_status)) +                    	# Uwaga 4. 
  geom_bar(fill="darkgray") + 
  facet_wrap(~housing_type, scale="free_x") +             	# Uwaga 5. 
  coord_flip()                                            	# Uwaga 6.

# Uwaga 1. 
#   Ogranicza dane do punktw, w ktrych znana jest warto housing_type. 

# Uwaga 2. 
#   Wykres supkowy grupowany. 

# Uwaga 3. 
#   Wykorzystuje funkcj coord_flip() to obrcenia wykresu, dziki czemu wartoci zmiennej marital_status staj si czytelne. 

# Uwaga 4. 
#   Fasetowany wykres supkowy. 

# Uwaga 5. 
#   Fasetuje wykres zgodnie ze zmienn housing.type. Argument scales="free_x" mwi nam, e kada faseta ma o x skalowan niezalenie od pozostaych; domylnie wszystkie fasety maj obydwie osie w takich samych skalach. Argument "free_y" uniezaleniby skale w osiach y, a argument "free" uniezaleniby obydwie osie. 

# Uwaga 6. 
#   Wykorzystuje funkcj coord_flip() to obrcenia wykresu. 

