#
# Dodatkowa funkcja służąca do realizacji przykładu z podpunktu 6.3.2
# w książce "Język R i analiza danych w praktyce. Wydanie II"
#

# w razie problemów zainstaluj pakiet xgboost:
# install.packages("xgboost")
library(xgboost)

#
# Dane wejściowe:
# - variable_matrix: macierz danych wejściowych
# - labelvvec: wektor numeryczny zawierający etykiety klas (1 oznacza klasę pozytywną)
#
# Zwraca:
# - model xgboost
#
fit_iris_example = function(variable_matrix, labelvec) {

  cv = xgb.cv(variable_matrix, label = labelvec,
              params=list(
                objective="binary:logistic"
              ),
              nfold=5,
              nrounds=100,
              print_every_n=10,
              metrics="logloss")

  evalframe = as.data.frame(cv$evaluation_log)
  NROUNDS = which.min(evalframe$test_logloss_mean)

  model = xgboost(data=variable_matrix, label=labelvec,
                  params=list(
                    objective="binary:logistic"
                  ),
                  nrounds=NROUNDS,
                  verbose=FALSE)

  model
}

