#
# Funkcje dodatkowe, służące do realizowania przykładów omówionych w podpunkcie 6.3.3
# książki "Język R i analiza danych w praktyce. Wydanie II"
#



library(wrapr)
library(xgboost)
# w razie problemów zainstaluj bibliotekę text2vec:
# install.packages("text2vec")
library(text2vec)


#
# funkcja przyjmująca korpus uczący (teksty)
# i zwracająca wokabularz: 10 000 słów pojawiających się
# w przynajmniej 10% dokumentów, ale mniej niż ich połowie.
#
create_pruned_vocabulary <- function(texts) {
  # tworzy iterator dla zbioru uczącego
  it_train <- itoken(texts,
                    preprocessor = tolower,
                    tokenizer = word_tokenizer,
                    ids = names(texts),
                    progressbar = FALSE)

  # króka lista pomijanych wyrazów
  stop_words <- qc(the, a, an, this, that, those, i, you)
  vocab <- create_vocabulary(it_train, stopwords = stop_words)

  # oczyszcza wokabularz
  # usuwa wszystkie wyrazy występujące zbyt często (co najmniej w połowie dokumentów)
  # usuwa wszystkie wyrazy występujące zbyt rzadko (w mniej niż 0,1% dokumentów)
  # pozostałą część ogranicza do 10 000 wyrazów
  pruned_vocab <- prune_vocabulary(
    vocab,
    doc_proportion_max = 0.5,
    doc_proportion_min = 0.001,
    vocab_term_max = 10000
  )

  pruned_vocab
}


# przyjmuje korpus i wokabularz,
# po czym zwraca macierz rzadką (rozumianą przez bibliotekę xgboost)
# w rzędach występują dokumenty, a w kolumnach są wyrazy z wokabularza
# tego typu reprezentacja ignoruje kolejność wyrazów w dokumentach
make_matrix <- function(texts, vocab) {
  iter <- itoken(texts,
                preprocessor = tolower,
                tokenizer = word_tokenizer,
                ids = names(texts),
                progressbar = FALSE)
  create_dtm(iter, vocab_vectorizer(vocab))
}

#
# Dane wejściowe:
# - dtm_train: macierz termów klasy dgCmatrix
# - labelvvec: wektor numeryczny etykiet klas (1 oznacza klasę pozytywną)
#
# Zwraca:
# - model xgboost
#
fit_imdb_model <- function(dtm_train, labels) {
  # oblicza oszacowanie liczby tur wymaganej przez
  # bibliotekę xgboost
  # cv <- xgb.cv(dtm_train, label = labels,
  #             params=list(
  #               objective="binary:logistic"
  #               ),
  #             nfold=5,
  #             nrounds=500,
  #             print_every_n=10,
  #             metrics="logloss")
  #
  # evalframe <- as.data.frame(cv$evaluation_log)
  # NROUNDS <- which.min(evalframe$test_logloss_mean)

  # uruchomiliśmy to już wcześniej, więc poniżej znajduje się dobra odpowiedź
  NROUNDS <- 371


  model <- xgboost(data=dtm_train, label=labels,
                  params=list(
                    objective="binary:logistic"
                  ),
                  nrounds=NROUNDS,
                  verbose=FALSE)

  model
}

