# przykad 10.2 z punktu 10.1.2 
# (przykad 10.2 z punktu 10.1.2)  : Zaawansowane metody uczenia maszynowego : Metody drzewa : Usprawnianie przewidywa za pomoc agregacji 
# Tytu: Agregacja drzew decyzyjnych 

ntrain <- dim(spamTrain)[1] 
n <- ntrain                                                	# Uwaga 1.  
ntree <- 100

samples <- sapply(1:ntree,                                	# Uwaga 2.  
                  FUN = function(iter)
                  { sample(1:ntrain, size = n, replace = TRUE) })

treelist <-lapply(1:ntree,                                 	# Uwaga 3.  
                  FUN = function(iter) {
                    samp <- samples[, iter];
                    rpart(spamFormula, spamTrain[samp, ], method = "class") })

predict.bag <- function(treelist, newdata) {               	# Uwaga 4.  
  preds <- sapply(1:length(treelist),
                  FUN = function(iter) {
                    predict(treelist[[iter]], newdata = newdata)[, 2] })
  predsums <- rowSums(preds)
  predsums / length(treelist)
}

pred <- predict.bag(treelist, newdata = spamTrain)
trainperf_bag <- accuracyMeasures(pred,                    	# Uwaga 5.  
                                  spamTrain$spam == "spam",
                                  name = "agregacja, uczacy")

pred <- predict.bag(treelist, newdata = spamTest)
testperf_bag <- accuracyMeasures(pred,
                                 spamTest$spam == "spam",
                                 name = "agregacja, testowy")

perftable <- rbind(trainperf_bag, testperf_bag)
pandoc.table(perftable, justify = perf_justify)
## 
## 
## model                      accuracy       f1   dev.norm
## ------------------------ ---------- -------- ----------
## agregacja, uczacy            0.9167   0.8917     0.5080
## agregacja, testowy           0.9127   0.8824     0.5793

# Uwaga 1.
#   Wykorzystuje przykady losowane metod samowsporn o takim samym rozmiarze, jaki ma zbir uczcy, a take wyznacza 100 drzew. 

# Uwaga 2. 
#   Tworzy przykady poprzez losowanie indeksw rzdw obiektu spamTrain ze zwracaniem. Kada kolumna macierzy samples reprezentuje indeksy rzdw spamTrain, tworzce prb samowsporn. 

# Uwaga 3. 
#   Uczy poszczeglne drzewa decyzyjne i zwraca je w postaci listy. Uwaga: etap ten moe zaj kilka minut. 

# Uwaga 4. 
#   Zakadamy w predict.bag, e uywany klasyfikator zwraca prawdopodobiestwa decyzyjne, a nie same decyzje. Przyjmowane s tu rednie przewidywa ze wszystkich pojedynczych drzew. 

# Uwaga 5. 
#   Ocenia zagregowane drzewa decyzyjne na zbiorach uczcym i testowym. 

