data <- read.table("natal2010Proba.tsv.gz",
                   sep="\t", header=T, stringsAsFactors=F)

# przekształca dane potwierdzenia/zaprzeczenia (Y/N) w wartości logiczne
makevarYN = function(col) {
  ifelse(col %in% c("", "U"), NA, ifelse(col=="Y", T, F))
}

# tworzy zmienne numeryczne zawierające wartości NA z danych numerycznych
makevarNum = function(col, sentinel) {
  ifelse(col==sentinel, NA, col)
}

# tworzy wartości logiczne z danych 1/2/9
makevar12 = function(col) {
  ifelse(col==9, NA, ifelse(col==1, T, F))
}

# zażywanie tytoniu: CIG_REC (Y, N, U, Blank)
data$CIG_REC = makevarYN(data$CIG_REC)

# waga matki w czasie połogu, waga matki przed połogiem (w funtach)
# ograniczona do 400 funtów
data$PWGT = makevarNum(data$PWGT, 999)
# waga noworodka
data$DWGT = makevarNum(data$PWGT, 999)
# przyrost wagi w czasie ciąży
data$WTGAIN = makevarNum(data$WTGAIN, 99)
# masa urodzeniowa w gramach
data$DBWT = makevarNum(data$DBWT, 9999)
# wiek matki
data$MAGER = makevarNum(data$MAGER, 99) # 

# liczba badań prenatalnych
data$UPREVIS = makevarNum(data$UPREVIS, 99)

# Nie korzystamy z poniższego kodu w książce, ale zostawię go na wszelki wypadek

# czynniki ryzyka (1,2,9,Blank)
# cukrzyca, przewlekłe nadciśnienie, nadciśnienie ciążowe, rzucawka porodowa
riskfactors = c("URF_DIAB", "URF_CHYPER", "URF_PHYPER", 
                "URF_ECLAM")
data[, riskfactors] = as.data.frame(lapply(data[, riskfactors], FUN=makevar12))

# zeruje poziom "domyślny" zmiennych kategorialnych
recode = function(col, map, ref) {
  relevel(as.factor(map[col]), ref=ref)
}

# długość trwania ciąży
# GESTREC3 (1,2,3 -- <37 tygodni, >=37 tygodni, NA)
grmap = c("< 37 weeks",
          ">= 37 weeks",
          NA)
data$GESTREC3 = recode(data$GESTREC3, grmap, grmap[[2]])

# DPLURAL : liczebność noworodków
plmap = c("single",
          "twin",
          "triplet or higher",
          "triplet or higher",
          "triplet or higher")
data$DPLURAL = recode(data$DPLURAL, plmap, "single")

x = c("PWGT", 
      "WTGAIN",
      "MAGER",
      "UPREVIS", 
      "CIG_REC",
      "GESTREC3",
      "DPLURAL",
      riskfactors)

sdata = data[, c(x, c("DBWT", "ORIGRANDGROUP"))]

# uzuwa wartości NA przed podziałem danych na zbiory uczący i testowy
# noNAs ma wartość T, jeśli nie ma w rzędzie żadnej wartości NA
noNAs = rowSums(as.data.frame(lapply(sdata, FUN=is.na))) == 0
sdata = sdata[noNAs, ]

save(sdata, file="NatalBirthData.rData")
