# przykad B.7 z punktu B.1.4 
# (przykad B.7 z punktu B.1.4)  : Wane pojcia z dziedziny statystyki : Rozkady : Rozkad dwumianowy 
# Tytu: Tworzenie wykresu rozkadu dwumianowego

library(ggplot2)
#
# generuje krzywe teoretycznego rozkadu dwumianowego za pomoc funkcji dbinom
#

numflips <- 50
# x jest liczb zaobserwowanych reszek
x <- 0:numflips

# prawdopodobiestwo wylosowania reszek dla kilku rnych monet
p <- c(0.05, 0.15, 0.5, 0.75)
plabels <- paste("p =", p)

# oblicza prawdopodobiestwo zaobserwowania x reszek w numflips rzutw
# dla wszystkich monet. Prawdopodobnie rozwizanie to nie jest najelegantsze,
# ale jest przynajmniej czytelne

flips <- NULL
for(i in 1:length(p)) {
  coin <- p[i]
  label <- plabels[i]
  tmp <- data.frame(number_of_heads=x,
                    probability = dbinom(x, numflips, coin),
                    coin_type = label)
  flips <- rbind(flips, tmp)
}


# tworzy wykres
# jest to gwny wykres w tym punkcie
ggplot(flips, aes(x = number_of_heads, y = probability)) +
  geom_point(aes(color = coin_type, shape = coin_type)) +
  geom_line(aes(color = coin_type))

