# przykad 8.4 z podrozdziau 8.3 
# (przykad 8.4 z podrozdziau 8.3)  : Zaawansowane przygotowywanie danych : Podstawowe przygotowywanie danych do zada klasyfikacji 
# Tytu: Podstawowe przygotowywanie danych do klasyfikacji 

library("vtreat")                                               	# Uwaga 1. 

(parallel_cluster <- parallel::makeCluster(parallel::detectCores()))  	# Uwaga 2. 

treatment_plan <- vtreat::designTreatmentsC(                        	# Uwaga 3. 
  dTrain, 
  varlist = vars, 
  outcomename = "churn", 
  outcometarget = 1, 
  verbose = FALSE,
  parallelCluster = parallel_cluster)

# Uwaga 1. 
#   Docza pakiet vtreat, co pozwala nam korzysta z takich funkcji jak designTreatmentsC(). 

# Uwaga 2. 
#   Uruchamia rwnolegy klaster przyspieszajcy obliczenia. Jeeli nie potrzebujesz rwnolegego klastra, wyznacz warto NULL dla parallel_cluster. 

# Uwaga 3. 
#   Uywa funkcji designTreatmentsC() do wyznaczenia planu naprawy na podstawie danych uczcych. W przypadku zestawu danych o takim rozmiarze i zoonoci jak KDD Cup 2009 moe zaj to kilka minut. 

