# przykad 9.5 z punktu 9.1.3 
# (przykad 9.5 z punktu 9.1.3)  : Metody nienadzorowane : Analiza skupie : Hierarchiczna analiza skupie za pomoc funkcji hclust() 
# Tytu: Odwzorowanie skupie na dwie pierwsze gwne skadowe 

library(ggplot2)
princ <- prcomp(pmatrix)                                       	# Uwaga 1. 
nComp <- 2
project <- predict(princ, pmatrix)[, 1:nComp]                  	# Uwaga 2. 
project_plus <- cbind(as.data.frame(project),                  	# Uwaga 3. 
                      cluster = as.factor(groups),
                      country = protein$Country)

ggplot(project_plus, aes(x = PC1, y = PC2)) +                  	# Uwaga 4. 
  geom_point(data = as.data.frame(project), color = "darkgrey") + 
  geom_point() +
  geom_text(aes(label = country),
            hjust = 0, vjust = 1) + 
  facet_wrap(~ cluster, ncol = 3, labeller = label_both)

# Uwaga 1. 
#   Oblicza gwne skadowe danych 

# Uwaga 2. 
#   Funkcja predict() obrci dane zgodnie ze wsprzdnymi wyznaczonymi przez gwne skadowe. Dwie pierwsze kolumny obrconych danych to odwzorowanie tych danych na dwie pierwsze gwne skadowe. 

# Uwaga 3. 
#   Tworzy ramk danych zawierajc przeksztacone dane, a take etykiet skupienia i etykiet pastwa dla kadego punktu.  

# Uwaga 4. 
#   Tworzy wykres gwnych skadowych. Dla zwikszenia czytelnoci umieszczamy poszczeglne skupienia w osobnych fasetach. 

