# przykad 8.9 z punktu 8.6.6 
# (przykad 8.9 z punktu 8.6.6)  : Zaawansowane przygotowywanie danych : Opanowanie pakietu vtreat : Ramka krzyowa 
# Tytu: Zagroenia zwizane z wielokrotnym stosowaniem danych 

plan5 <- vtreat::designTreatmentsN(d,                      	# Uwaga 1. 
                                   varlist = c("x_zla", "x_dobra"),
                                   outcomename = "y",
                                   codeRestriction = "catN",
                                   minFraction = 2,
                                   verbose = FALSE)

class(plan5)
# [1] "treatmentplan"

print(plan5)                                                	# Uwaga 2. 
#   origName       varName code          rsq          sig extraModelDegrees
# 1    x_zla    x_zla_catN catN 4.906903e-05 9.448548e-01                24
# 2   x_dobra x_dobra_catN catN 2.602702e-01 5.895285e-08                 1

dane_uczace1 <- vtreat::prepare(plan5, d)                  	# Uwaga 3. 

wyn1 <- vtreat::patch_columns_into_frame(d, dane_uczace1)    	# Uwaga 4.
head(wyn1)
#   x_zla  x_dobra x_zla_catN x_ddobra_catN           y
# 1     u  nie-neg  0.4070979     0.4305195 -0.05294738
# 2     s      neg -0.1133011    -0.5706886 -0.23639840
# 3     h  nie-neg -0.3202346     0.4305195 -0.33796351
# 4     q  nie-neg -0.5447443     0.4305195 -0.75548467
# 5     b      neg -0.3890076    -0.5706886 -0.86159347
# 6     b  nie-neg -0.3890076     0.4305195 -0.52766549

sigr::wrapFTest(wyn1, "x_dobra_catN", "y")              	# Uwaga 5. 
# [1] "F Test summary: (R2=0.2717, F(1,98)=36.56, p<1e-05)."

sigr::wrapFTest(wyn1, "x_zla_catN", "y")               	# Uwaga 6. 
# [1] "F Test summary: (R2=0.2342, F(1,98)=29.97, p<1e-05)."

# Uwaga 1. 
#   Projektuje plan naprawy zmiennych tak, eby zmienne x_zla i x_dobra przewidyway zmienn y. 

# Uwaga 2. 
#   Zwr uwag, e zmienna pochodna x_dobra_catN cechuje si istotnym sygnaem, w przeciwiestwie do zmiennej x_zla_catN. Wynika to z odpowiedniego uycia sprawdzianu krzyowego w oszacowaniach jakoci.

# Uwaga 3. 
#   Wywouje metod prepare() na tych samych danych, ktre zostay uyte do stworzenia planu naprawy; jak si przekonamy, takie rozwizanie nie zawsze jest bezpieczne. 

# Uwaga 4. 
#   czy ramki danych d i dane_uczace1 i korzysta z ramki dane_uczace1 tam, gdzie znajduj si kolumny ze zduplikowanymi nazwami. 

# Uwaga 5. 
#   Wykorzystuje statystyczny test F, za pomoc ktrego sprawdzamy moc predykcyjn zmiennej x_dobra_catN.  

# Uwaga 6. 
#   Test F zmiennej x_zla_catN daje zawyony wynik i zudne wraenie istotnoci. Wynika to z bdnego uycia metod sprawdzianu krzyowego. 

