# przykad 10.22 z punktu 10.3.1 
# (przykad 10.22 z punktu 10.3.1)  : Zaawansowane metody uczenia maszynowego : Rozwizywanie problemw nierozdzielnych za pomoc maszyn wektorw nonych : Uywanie maszyn SVM do rozwizywania problemw 
# Tytu: Przygotowywanie danych spiralnych jako problemu klasyfikacji 

library('kernlab')
data(spirals)                                  		# Uwaga 1. 
sc <- specc(spirals, centers = 2)            		# Uwaga 2. 
s <- data.frame(x = spirals[, 1], y = spirals[, 2],  	# Uwaga 3. 
                class = as.factor(sc)) 	

library('ggplot2') 
ggplot(data = s) +                                  	# Uwaga 4. 
  geom_text(aes(x = x, y = y,
                label = class, color = class)) +
  scale_color_manual(values = c("#d95f02", "#1b9e77")) +
  coord_fixed() + 
  theme_bw() + 
  theme(legend.position  = 'none') +
  ggtitle("Przykadowe zadanie: rozdziel jedynki od dwjek")

# Uwaga 1. 
#   Wczytuje jdro kernlab i pakiet z maszynami SVM, po czym generuje dane spiralne. 

# Uwaga 2. 
#   Wykorzystuje procedur widmowej analizy skupie do wyznaczenia dwch rnych spiral w przykadowym zestawie danych. 

# Uwaga 3. 
#   Combine the spiral coordinates and the 
#   spiral label into a data frame. 

# Uwaga 4. 
#   czy wsprzdne spiral i etykiety w ramce danych. 

