# przykad 10.15 z punktu 10.2.2 
# (przykad 10.15 z punktu 10.2.2)  : Zaawansowane metody uczenia maszynowego : Wykrywanie relacji niemonotonicznych za pomoc uoglnionych modeli addytywnych : Przykad regresji jednowymiarowej 
# Tytu: Porwnywanie wydajnoci regresji liniowej i modelu GAM  

test <- transform(test,                                   	# Uwaga 1. 
                  pred_lin = predict(lin_model, test),
                  pred_gam = predict(gam_model, test) )


test <- transform(test,                                   	# Uwaga 2. 
                  resid_lin = y - pred_lin,
                  resid_gam = y - pred_gam)


rmse(test$resid_lin)                                      	# Uwaga 3.  
## [1] 2.792653

rmse(test$resid_gam)
## [1] 1.401399


library(sigr)                                            	# Uwaga 4.
wrapFTest(test, "pred_lin", "y")$R2
## [1] 0.115395

wrapFTest(test, "pred_gam", "y")$R2
## [1] 0.777239

# Uwaga 1. 
#   Uzyskuje przewidywania z obydwu modeli dla danych testowych. Funkcja transform() stanowi odpowiednik funkcji dplyr::mutate() w bazowym R. 

# Uwaga 2. 
#   Oblicza wartoci resztowe. 

# Uwaga 3. 
#   Porwnuje bd RMSE obydwu modeli dla danych testowych. 

# Uwaga 4. 
#   Porwnuje wspczynnik determinacji obydwu modeli dla danych testowych za pomoc pakietu sigr. 

