# przykad 10.5 z punktu 10.1.3 
# (przykad 10.5 z punktu 10.1.3)  : Zaawansowane metody uczenia maszynowego : Metody drzewa : Dalsze usprawnianie przewidywa za pomoc lasw losowych 
# Tytu: Dopasowywanie modelu za pomoc mniejszej liczby zmiennych  

sorted <- sort(varImp[, "MeanDecreaseAccuracy"],       	# Uwaga 1. 
               decreasing = TRUE)

selVars <- names(sorted)[1:30]
fsel <- randomForest(x = spamTrain[, selVars],             	# Uwaga 2. 
                     y = spamTrain$spam, 
                     ntree = 100,
                     nodesize = 7,
                     importance = TRUE)

trainperf_rf2 <- accuracyMeasures(predict(fsel,
                                          newdata = spamTrain[, selVars], type = 'prob')[, 'spam'],
                                  spamTrain$spam == "spam", name = "maly las losowy, uczacy")

testperf_rf2 <- accuracyMeasures(predict(fsel,
                                         newdata=spamTest[, selVars], type = 'prob')[, 'spam'],
                                 spamTest$spam == "spam", name = "maly las losowy, testowy")

perftable <- rbind(testperf_rf, testperf_rf2)              	# Uwaga 3. 
pandoc.table(perftable, justify = perf_justify)
##
##
## model                        accuracy       f1   dev.norm
## -------------------------- ---------- -------- ----------
## las losowy, testowy            0.9498   0.9341     0.3011
## maly las losowy, testowy       0.9520   0.9368     0.4000

# Uwaga 1. 
#   Sortuje zmienne zgodnie z ich istotnoci, okrelon na podstawie zmiany dokadnoci. 

# Uwaga 2. 
#   Tworzy model lasu losowego za pomoc jedynie 30 najistotniejszych zmiennych. 

# Uwaga 3. 
#   Porwnuje dwa modele lasu losowego na zbiorze testowym. 

