$(document).ready(function(){

/*  Nowe dodatki na koniec gry

	Do obiektu 'hand' dodano wicej opcji dla wygranej i przegranej
	Dodano przycisk restartu umoliwiajcy ponowne rozdanie
*/


	var used_cards = new Array();
	
	function card(name,suit,value) {
		this.name = name;
		this.suit = suit;
		this.value = value;
	} 
	
	var deck = [
		new card('As', 'Kier',11),
		new card('Dwjka', 'Kier',2),
		new card('Trjka', 'Kier',3),
		new card('Czwrka', 'Kier',4),
		new card('Pitka', 'Kier',5),
		new card('Szstka', 'Kier',6),
		new card('Sidemka', 'Kier',7),
		new card('semka', 'Kier',8),
		new card('Dziewitka', 'Kier',9),
		new card('Dziesitka', 'Kier',10),
		new card('Walet', 'Kier',10),
		new card('Krlowa', 'Kier',10),
		new card('Krl', 'Kier',10),
		new card('As', 'Karo',11),
		new card('Dwjka', 'Karo',2),
		new card('Trjka', 'Karo',3),
		new card('Czwrka', 'Karo',4),
		new card('Pitka', 'Karo',5),
		new card('Szstka', 'Karo',6),
		new card('Sidemka', 'Karo',7),
		new card('semka', 'Karo',8),
		new card('Dziewitka', 'Karo',9),
		new card('Dziesitka', 'Karo',10),
		new card('Walet', 'Karo',10),
		new card('Krlowa', 'Karo',10),
		new card('Krl', 'Karo',10),
		new card('As', 'Trefl',11),
		new card('Dwjka', 'Trefl',2),
		new card('Trjka', 'Trefl',3),
		new card('Czwrka', 'Trefl',4),
		new card('Pitka', 'Trefl',5),
		new card('Szstka', 'Trefl',6),
		new card('Sidemka', 'Trefl',7),
		new card('semka', 'Trefl',8),
		new card('Dziewitka', 'Trefl',9),
		new card('Dziesitka', 'Trefl',10),
		new card('Walet', 'Trefl',10),
		new card('Krlowa', 'Trefl',10),
		new card('Krl', 'Trefl',10),
		new card('As', 'Pik',11),
		new card('Dwjka', 'Pik',2),
		new card('Trjka', 'Pik',3),
		new card('Czwrka', 'Pik',4),
		new card('Pitka', 'Pik',5),
		new card('Szstka', 'Pik',6),
		new card('Sidemka', 'Pik',7),
		new card('semka', 'Pik',8),
		new card('Dziewitka', 'Pik',9),
		new card('Dziesitka', 'Pik',10),
		new card('Walet', 'Pik',10),
		new card('Krlowa', 'Pik',10),
		new card('Krl', 'Pik',10)
	];
	
	var hand = {
		cards : new Array(),
		current_total : 0,
		
		sumCardTotal: function(){
			this.current_total = 0;
			for(var i=0;i<this.cards.length;i++){
				var c = this.cards[i];
				this.current_total += c.value;
			}
			$("#hdrTotal").html("Razem: " + this.current_total );
			
			if(this.current_total > 21){
				$("#btnStick").trigger("click");
				$("#imgResult").attr('src','images/x2.png');
				$("#hdrResult").html("PRZEGRAE!").attr('class', 'lose');
			}else if(this.current_total == 21){
				$("#btnStick").trigger("click");
				$("#imgResult").attr('src','images/check.png');
				$("#hdrResult").html("Blackjack!").attr('class', 'win');
			}else if(this.current_total <= 21 && this.cards.length == 5){
				$("#btnStick").trigger("click");
				$("#imgResult").attr('src','images/check.png');
				$("#hdrResult").html("Masz 5 kart!").attr('class', 'win');
			}else{ }
		}
	};
	
	function getRandom(num){
		var my_num = Math.floor(Math.random()*num);
		return my_num;
	}
	
	function deal(){
		for(var i=0;i<2;i++){
			hit();
		}
	}
	
	function hit(){
		var good_card = false;
		do{
			var index = getRandom(52);
			if( !$.inArray(index, used_cards ) > -1 ){
				good_card = true;
				var c = deck[ index ];
				used_cards[used_cards.length] = index;
				hand.cards[hand.cards.length] = c;	
				
				var $d = $("<div>");
				$d.addClass("current_hand")
				  .appendTo("#my_hand");
						  
				$("<img>").attr('alt', c.name + ' ' + c.suit )
						  .attr('title', c.name + ' ' + c.suit )
						  .attr('src', 'images/karty/' + c.suit + '/' + c.name + '.jpg' )
						  .appendTo($d)
						  .fadeOut('slow')
						  .fadeIn('slow');
				
			}
		}while(!good_card);
		good_card = false;	  
		hand.sumCardTotal();
	}
	
	$("#btnDeal").click( function(){
		deal();
		$(this).toggle();
		$("#btnHit").toggle();
		$("#btnStick").toggle();
	});
	
	$("#btnHit").click( function(){
		hit();
	});
	
	function end(){
		$("#btnHit").toggle();
		$("#btnStick").toggle();
		$("#btnRestart").toggle();
	}
	
	$("#btnStick").click( function(){
		$("#hdrResult").html('Od nowa!')
					   .attr('class', 'win');
		$("#result").toggle();
		end();
	});
	
	$("#btnRestart").click( function(){
		$("#result").toggle();
		$(this).toggle();
		$("#my_hand").empty();
		$("#hdrResult").html('');
		$("#imgResult").attr('src','images/check.png');
		
		used_cards.length = 0;
		hand.cards.length = 0;
		hand.current_total = 0;
		
		$("#btnDeal").toggle()
					 .trigger('click');
	});
});
