<?php
    $isPartial = empty($_POST['partial']) ? false : true;

    // Wstępnie zdefiniowany zestaw komunikatów
    $messages = array(
        'required' => 'Pole %s jest wymagane.',
        'invalid' => 'Pole %s jest niepoprawne.',
        'errors' => 'Aby kontynuować, proszę usunąć błędy w formularzu.',
        'generic' => 'Z powodu wystąpienia błędu wiadomość nie została dostarczona. Spróbuj ponownie później: %s',
        'short' => 'Wartość pola %s jest za krótka. Minimalna liczba znaków, jakie musi zawierać to: %d.',
        'success' => 'Dziękuję %s za wiadomość. Została pomyślnie wysłana.'
    );

    // Wynik żądania
    $result = array(
        'status' => '',
        'message' => '',
        'info' => []
    );

    // Sprawdzenie imienia i nazwiska
    if (!$isPartial && $_POST['name'] === '') {
        $result['info'][] = array(
            'field' => 'name',
            'message' => sprintf($messages['required'], 'Imię i nazwisko')
        );
    } else if ((!$isPartial || isset($_POST['name'])) && strlen($_POST['name']) <= 3) {
        $result['info'][] = array(
            'field' => 'name',
            'message' => sprintf($messages['short'], 'Imię i nazwisko', 4)
        );
    }

    // Sprawdzenie adresu e-mail
    if (!$isPartial && $_POST['email'] === '') {
        $result['info'][] = array(
            'field' => 'email',
            'message' => sprintf($messages['required'], 'Adres e-mail')
        );
    } else if ((!$isPartial || isset($_POST['email'])) && !filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
        $result['info'][] = array(
            'field' => 'email',
            'message' => sprintf($messages['invalid'], 'Adres e-mail')
        );
    }

    // Sprawdzenie tematu
    if (!$isPartial && $_POST['subject'] === '') {
        $result['info'][] = array(
            'field' => 'subject',
            'message' => sprintf($messages['required'], 'Temat')
        );
    } else if ((!$isPartial || isset($_POST['subject'])) && strlen($_POST['subject']) <= 3) {
        $result['info'][] = array(
            'field' => 'subject',
            'message' => sprintf($messages['short'], 'Temat', 4)
        );
    }

    // Sprawdzenie wiadomości
    if (!$isPartial && $_POST['message'] === '') {
        $result['info'][] = array(
            'field' => 'message',
            'message' => sprintf($messages['required'], 'Wiadomość')
        );
    } else if ((!$isPartial || isset($_POST['message'])) && strlen($_POST['message']) <= 3) {
        $result['info'][] = array(
            'field' => 'message',
            'message' => sprintf($messages['short'], 'Wiadomość', 4)
        );
    }

    if (!empty($result['info'])) {
        $result['status'] = 'error';
        $result['message'] = $messages['errors'];
    } else {
        /*
         * Jeśli na komputerze działa serwer SMTP, usuń znaki komentarza
         * z tych wierszy, a także wiersz if(true) {.
         *
         *
         * if (mail(
         *    'email@domena.com',
         *    htmlentities($_POST['subject']),
         *    htmlentities($_POST['message']),
         *    'Od: ' . $_POST['name'] . ' <' . $_POST['email'] . '>'
         * )) {
         */
        if (true) {
            $result['status'] = 'success';
            if ($isPartial) {
                $result['message'] = '';
            } else {
                // Przykro mi, jeśli funkcja htmlentities brzmi nieznajomo,
                // ale jako programista mogę po prostu wystawić tę instrukcję na ataki XSS
                $result['message'] = sprintf($messages['success'], htmlentities($_POST['name']));
            }
        } else {
            $result['status'] = 'error';
            $result['message'] = sprintf($messages['generic'], htmlentities($_POST['name']));
        }
    }

    echo json_encode($result);