﻿<?php
/**
* @version $Id: joomlamap.php 5203 2007-06-15 02:45:14Z DanR $
* @copyright Copyright (C) 2007 Dan Rahmel. Wszystkie prawa zastrzeżone.
* @package Joomlamap
* Komponent łączący z usługą Map Google, wyświetla mapę dla wprowadzonego adresu
*/

// zablokuj bezpośredni dostęp
defined( '_JEXEC' ) or die( 'Brak dostępu' );

// Sprawdź wartość parametru task i uruchom właściwą funkcję
switch( JRequest::getVar( 'task' )) { 
   case 'goto': 
      gotoLocation(); 
      break; 
   default: 
      displayAddressEntry(); 
      break; 
}

// Przetwórz dane przesłane w formularzu
function gotoLocation()  {  
   $userKey = $params->get('key', 0);   
   // Pobierz wartość pola location z formularza
   $fldLocation = JRequest::getVar('location') ;
   // Usuń wszystko co mogłoby być kodem HTML itp.
   $fldQuery = preg_replace("/[^ąćęłńóśźża-zĄĆĘŁŃÓŚŹŻA-Z0-9 .?!$()\'\"]/", "", $fldQuery);
   // "
   echo "<h1>Twoja lokalizacja</h1>";
   echo "<p>Lokalizacja: " . $fldLocation . "<p>";
?>
	<div id="map" style="width: 400px; height: 300px;"></div>
   <script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=<?php echo $userKey; ?>" type="text/javascript"></script>

   <script type="text/javascript">

//<![CDATA[

   var map = null;
   var geocoder = null;

   function load() {
      if (GBrowserIsCompatible()) {
         map = new GMap2(document.getElementById("map"));
         map.setCenter(new GLatLng(37.4419, -122.1419), 13);
         geocoder = new GClientGeocoder();
      }
   }
	function showAddress(address) {
      if (geocoder) {
        geocoder.getLatLng(
          address,
          function(point) {
            if (!point) {
              alert(address + " not found");
            } else {
              map.setCenter(point, 13);
              var marker = new GMarker(point);
              map.addOverlay(marker);
              marker.openInfoWindowHtml(address);
				  map.addControl(new GSmallZoomControl ());
            }
          }
        );
      }
    }

//]]>
   load();
   showAddress('<?php echo $fldLocation;  ?>');
   </script>

<?php 
   echo "<a href=index.php?option=com_joomlamap>" . 
      "Wróć do Joomlamap</a>";
}
     
// Wyświetl formularz do wprowadzania adresu
function displayAddressEntry() {     
?>
<h1 class="contentheading">Formularz wyszukiwania mapy</h1>

<form id="form1" name="form1" method="post"
   action="index.php?option=com_joomlamap&task=goto">
   <p>Wprowadź adres:<br /> 
      <textarea name="location" cols="60" rows="1" id="location"></textarea>
   </p>
   <p>
      <input type="submit" name="Submit" value="Wyświet lokalizację" />
   </p>
</form>

<?php } ?>