﻿<?php
/**
* @version $Id: guestbook.php 5203 2007-06-15 02:45:14Z DanR $
* @copyright (C) 2007 Dan Rahmel, wszystkie prawa zastrzeżone.
* @package Księga gości
* Komponent ten wyświetla listę wpisów w księdze kgości i umożliwia dodawanie 
* nowych komentarzy przez zarejestrowanych użytkowników
*/

// zablokuj bezpośredni dostęp
defined( '_JEXEC' ) or die ( 'Brak dostępu' );

// Sprawdź wartość parametru task i wywołaj odpowiednią funkcję
switch( JRequest::getVar( 'task' )) {
   case 'edit':
      editEntry();
      break;
   case 'update':
      updateEntry();
      break;
   default:
      displayEntries();
      break;
}

// Zapisz dane pobrane z formularza
function updateEntry() {
   // Ustaw tytuł w interfejsie administratora
   JToolBarHelper::title( JText::_( 'Uaktualnianie wpis w księdze gości' ), 'addedit.png' );

   // Pobierz referencję do obiektu bazy danych
   $db =& JFactory::getDBO();

   // Pobierz dane z formularza
   $fldMessage = "'" . $db->getEscaped(JRequest::getVar( 'message' )) . "'";
   $fldLocation = "'" . $db->getEscaped(JRequest::getVar( 'location' )) . "'";
   $fldID = "'" . $db->getEscaped(JRequest::getVar( 'id' )) . "'";

   // Zapisz zmiany w tabeli jos_guestbook
   $insertFileds = "UPDATE #__guestbook " .
      " SET message= " . $fldMessage . ", " .
      " location=" .$fldLocation .
      " WHERE id = " . $fldID ;
   $db->setQuery( $insertFields, 0);
   $db->query();
   echo "<h3>Uaktualniono wpis!</h3>";
   echo "<a href='index.php?option=com_guestbook'>Powrót do listy wpisów</a>";
}

// Wyświetl listę wpisów z księgi gości
function displayEntries() {
   // Ustaw tytuł w interfejsie administratora
   JToolBarHelper::title( JText::_( 'Wpisy w księdze gości' ), 'addedit.png' );

   // Wykonaj zapytanie i pobierz listę wpisów
   $db =& JFactory::getDBO();
   $query = "SELECT a.id, a.message, a.created, a.created_by, u.name" .
   " FROM #__guestbook AS a" .
   " LEFT JOIN #__users AS u ON u.id=a.created_by" .
   " ORDER BY created DESC";
   $db->setQuery( $query, 0, 10 );
   $rows = $db->loadObjectList();
?>
<table class="adminlist">
<tr>
   <td class="title" width=10%>
      <strong><?php echo JText::_( 'ID wpisu' ); ?></strong>
   </td>
   <td class="title" width=50%>
      <strong><?php echo JText::_( 'Wpis' ); ?></strong>
   </td>
   <td class="title" width=10%>
      <strong><?php echo JText::_( 'Utworzono' ); ?></strong>
   </td>
   <td class="title" width=10%>
      <sttrong><?php echo JText::_( 'Przez' ); ?></strong>
   </td>
</tr>

<?php
   foreach ($rows as $row) {
      $link = 'index.php?option=com_guestbook&task=edit&id=' . $row->id;
      // Przytnij treść wyświetlanych wiadomości
      $rowMessage = $row->message;
      if(strlen($rowMessage) > 100) {
         $rowMessage = substr($rowMessage, 0, 100) . "...";
      }
      echo "<tr>" .
         "<td>" . $row->id ."</td>" .
         "<td><a href=" . $link . ">" . $rowMessage . "</a></td>" .
         "<td>" . $row->created . "</td>" .
         "<td>" . $row->name . "</td>" .
         "</tr>";
   }
   echo "</table>";
   echo "<h3>Kliknij treść wpisu w tabeli, aby przejść do ekranu edycji.</h3>";
}

function editEntry() {
   JToolBarHelper::title( JText::_( 'Edycja wpisu księgi gości' ), 'addedit.png' );

   $db =& JFactory::getDBO();
   $query = "SELECT a.id, a.message, a.created, a.created_by, a.location" .
   " FROM #__guestbook AS a" .
   " WHERE a.id = " . JRequest::getVar( 'id' );
   $db->setQuery( $query, 0, 10 );
   if ($rows = $db->loadObjectList()) {
?>

<form id="form1" name="form1" method="post"
  action="index.php?option=com_g;uestbook&task=update">
   <p>Wprowadź treść wiadomości:<br />
      <textarea name="message" cols="60" rows="4" id="message"><?php
        echo $rows[0]->message;
      ?></textarea>
   </p>
   <p>
      <label>Lokacja (opcjonalnie) : </label>
      <input name="location" type="text" id="location"
        value='<?php echo $rows[0]->location; ?>' />
      <input name="id" type="hidden" id="id"
        value='<?php echo $rows[0]->id; ?>' />
   </p>
   <p>
      <input type="submit" name="Submit" value="Zapisz zmiany" />
   </p>
</form>

<?php }    } ?>