<?php
/*
// JoomlaWorks "Development" Template for Joomla! 1.5.x - Version 1.0
// Copyright (c) 2006 - 2009 JoomlaWorks Ltd.
// Released under the GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
// More info at http://www.joomlaworks.gr
// Designed and developed by the JoomlaWorks team
// ***Last update: June 16th, 2009***
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * This is a file to add template specific chrome to pagination rendering.
 *
 * pagination_list_footer
 * 	Input variable $list is an array with offsets:
 * 		$list[limit]		: int
 * 		$list[limitstart]	: int
 * 		$list[total]		: int
 * 		$list[limitfield]	: string
 * 		$list[pagescounter]	: string
 * 		$list[pageslinks]	: string
 *
 * pagination_list_render
 * 	Input variable $list is an array with offsets:
 * 		$list[all]
 * 			[data]		: string
 * 			[active]	: boolean
 * 		$list[start]
 * 			[data]		: string
 * 			[active]	: boolean
 * 		$list[previous]
 * 			[data]		: string
 * 			[active]	: boolean
 * 		$list[next]
 * 			[data]		: string
 * 			[active]	: boolean
 * 		$list[end]
 * 			[data]		: string
 * 			[active]	: boolean
 * 		$list[pages]
 * 			[{PAGE}][data]		: string
 * 			[{PAGE}][active]	: boolean
 *
 * pagination_item_active
 * 	Input variable $item is an object with fields:
 * 		$item->base	: integer
 * 		$item->link	: string
 * 		$item->text	: string
 *
 * pagination_item_inactive
 * 	Input variable $item is an object with fields:
 * 		$item->base	: integer
 * 		$item->link	: string
 * 		$item->text	: string
 *
 * This gives template designers ultimate control over how pagination is rendered.
 *
 * NOTE: If you override pagination_item_active OR pagination_item_inactive you MUST override them both
 */

function pagination_list_footer($list){
	$html = "
	<div class=\"list-footer\">
		<div class=\"limit\">".JText::_('Display Num').$list['limitfield']."</div>
		".$list['pageslinks']."
		<div class=\"counter\">".$list['pagescounter']."</div>
		<input type=\"hidden\" name=\"limitstart\" value=\"".$list['limitstart']."\" />
	</div>
	";
	return $html;
}

function pagination_list_render($list){
	// Initialize variables
	$html  = "<span class=\"pagination\">";
	$html .= '<span>&laquo;</span>'.$list['start']['data'];
	$html .= $list['previous']['data'];

	foreach( $list['pages'] as $page ){
		if($page['data']['active']) {
			$html .= '<strong>';
		}

		$html .= $page['data'];

		if($page['data']['active']) {
			$html .= '</strong>';
		}
	}

	$html .= $list['next']['data'];
	$html .= $list['end']['data'];
	$html .= '<span>&raquo;</span>';
	$html .= "</span>";
	return $html;
}

function pagination_item_active(&$item){
	return "<a href=\"".$item->link."\" title=\"".$item->text."\">".$item->text."</a>";
}

function pagination_item_inactive(&$item){
	return "<span>".$item->text."</span>";
}
