<?php

// brak bezporedniego dostpu
defined('_JEXEC') or die('Brak dostpu');

/**
 * Odczytuje typ MIME pliku. cieka dostpu do adowanego
 * pliku bdzie si znajdowa w $uploadFile['tmp_name'], za domylnym
 * typem MIME bdzie $uploadFile['type'] lub podobny.
 *
 * @paramm string $pathToFile Pena cieka dostpu do pliku, ktrego typ MIME trzeba odczyta
 * @param string $default Domylny typ MIME
 * @return int
 */
function getFileMIME_Type($pathToFile, $default) {
    if (function_exists('finfo_file')) {
        // uycie rozszerzenia PECL Fileinfo
        $finfo    = finfo_open(FILEINFO_MIME);
        $mimeType = finfo_file($finfo, $pathToFile);
        finfo_close($finfo);
    } elseif (function_exists('mime_content_type')) {
        // uycie funkcji PHP mime_content_type()
        $mimeType = mime_content_type($pathToFile);
    } else {
        // uycie danych pochodzcych od klienta
        $mimeType = $uploadFile['type'];
    }
    
    return $mimeType;
}
