<?php
/**
 * Foobar search plugin
 */

// brak bezporedniego dostpu
defined( '_JEXEC' ) or die( 'Brak dostpu' );

/**
 * Modu dodatkowy, ktry przeszukuje komponent Foobars
 */
class plgSearchFoobar extends JPlugin {

    /**
     * @return array Odczytuje asocjacyjn tablic obszarw, ktre mona przeszukiwa
     */
    function &onSearchAreas()
    {
        static $areas = array(
            'content' => 'Artykuy',
            'foobar'  => 'Foobars'
        );
        return $areas;
    }

    /**
     * Metoda przeszukiwania moduu dodatkowego Foobar. Odczytuje tablic obiektw,
     * z ktrych kady zawiera zmienne instancji title, text,
     * href, section, created oraz browsernav
     *
     * @param string $text Wyszukiwany cig znakw
     * @param string $phrase Dopasowanie: exact|any|all
     * @param string $ordering Sposb porzdkowania wynikw: newest|oldest|popular|alpha|category
     * @param array  $areas Obszary, w ktrych mona szuka; null spowoduje przeszukanie wszystkich obszarw
     * @return array Obiekty reprezentujce obszary foobar
     */
    function onSearch($text, $phrase="", $ordering="", $areas=null) {
        // sprawdzenie, czy mona wykona dane wyszukiwanie
        if (is_array($areas) && !in_array("foobar", $areas)) {
            // to nie jest aden z naszych obszarw  koczymy dziaanie
            return array();
        }

        // pobranie potrzebnego obiektu
        $db   =& JFactory::getDBO();

        // utworzenie klauzuli WHERE z warunkami dla zapytania SQL
        $conditions = "";
        switch ($phrase) {
            case "exact":
                // sformuowanie warunku LIKE dla wyszukiwania dokadnego
                $text = $db->Quote("%".$db->getEscaped($text, true)."%", false);
                $conditions = $db->nameQuote("foobar")." LIKE ".$text;
                break;
            case "all":
            case "any":
            default:
                // wyodrbnienie pojedynczych sw z poszukiwanego cigu
                $wordsConditions = array();
                foreach (preg_split("~\s+~", $text) as $word) {
                    $word = $db->Quote( "%".$db->getEscaped( $word, true )."%", false );
                    $wordsConditions[] = $db->nameQuote("foobar")." LIKE ".$word;
                }
                // ustalenie spjnika midzy sowami i zoenie sw i spjnikw w jeden cig
                $glue = ($phrase == "all") ? ") AND (" : ") OR (";
                $conditions = "(".implode($glue, $wordsConditions).")";
                break;
        }

        // ustalenie metody porzdkowania wynikw
        switch ($ordering) {
            case 'popular':
                $order = 'hits DESC';
                break;
            case 'alpha':
            case 'category':
                $order = 'foobar ASC';
                break;
            case 'oldest':
                $order = 'created ASC';
                break;
            case 'newest':
            default:
                $order = 'created DESC';
                break;
        }

        // wykoczenie zapytania
        $query = 'SELECT foobar AS title, foobar AS text, created,'
        . ' "Foobars" AS section, "2" AS browsernav, '
        . ' CONCAT("index.php?option=com_foobar&id=", id) AS href'
        . ' FROM ' . $db->nameQuote('#__foobar')
        . ' WHERE ( '.$conditions.' )'
        . ' ORDER BY '. $order;
        $db->setQuery($query);
        $rows = $db->loadObjectList();

        return $rows;
    }

}
