<?php

// brak bezporedniego dostpu
defined('_JEXEC') or die('Brak dostpu');

/**
 * Odczytuje maksymalny dozwolony rozmiar
 * adowanych plikw wyraony w bajtach.
 *
 * @return int
 */
function getMaximumUploadSizeInBytes() {
    $uploadSize = trim(ini_get('upload_max_filesize'));
    $last = strtolower($uploadSize[strlen($uploadSize)-1]);
    switch($last) {
        // modyfikator 'G' jest dostpny od wersji PHP 5.1.0
        case 'g':
            $uploadSize *= 1024;
        case 'm':
            $uploadSize *= 1024;
        case 'k':
            $uploadSize *= 1024;
    }

    return $uploadSize;
}

/**
* Odczytuje maksymalny dozwolony rozmiar
 * adowanych plikw wyraony w megabajtach.
 *
 * @return int
 */
function getMaximumUploadSizeInMegaBytes() {
    $bytes = $this->getMaximumUploadSizeInBytes();
    return $bytes / 1048576;
}
