<?php
/**
 * Funkcja instalacji komponentu My Component
 */

// Nie pozwalamy na bezporednie czenie
defined('_JEXEC') or die('Brak dostpu');

/**
 * Installation function for My Component
 */
function com_install() {
    // zaadowanie pliku tumaczenia dla informacji zwracanych w trakcie instalacji
    $lang = & JFactory::getLanguage();
    $lang->load('com_mycomponent');
    
    // Pobranie instalatorw, DBO oraz cieki dostpu do plikw instalacyjnych moduu dodatkowego
    $componentInstaller =& JInstaller::getInstance();
    $installer = new JInstaller();
    $db =& JFactory::getDBO();
    $pathToPlgMylibrary = $componentInstaller->getPath('source') . DS . 'plg_mylibrary';
    
    // pobranie biblioteki My Library, jeeli ju j zainstalowano
    $query = 'SELECT COUNT(*)' 
           . ' FROM ' . $db->nameQuote('#__plugins')
           . ' WHERE ' . $db->nameQuote('element') . ' = ' . $db->Quote('mylibrary')
           . ' AND ' .   $db->nameQuote('folder')  . ' = ' . $db->Quote('library');
    $db->setQuery($query);
    $myLibraryInstalled = (bool)$db->loadResult();

    // ustalenie, co trzeba robi dalej
    if ($myLibraryInstalled) {
        // biblioteka ju zainstalowana
        echo '<p>'.JText::_('WYMAGANE ROZSZERZENIE MY LIBRARY JEST JU ZAINSTALOWANE').'</p>';
    } else {
        // zainstalowanie moduu dodatkowego My Library
        if (!$installer->install($pathToPlgMylibrary)) {
            echo '<p>'.JText::_('NIE UDAO SI ZAINSTALOWA WYMAGANEGO MODUU DODATKOWEGO MY LIBRARY').'</p>';
        } else {
            echo '<p>'.JText::_('WYMAGANE ROZSZERZENIE MY LIBRARY ZOSTAO ZAINSTALOWANE').'</p>";
        }
    }
    
    // opublikowanie biblioteki My Library
    $query = 'UPDATE ' . $db->nameQuote('#__plugins')
           . ' SET ' . $db->nameQuote('published') . ' = 1'
           . ' WHERE ' . $db->nameQuote('element') . ' = ' . $db->Quote('mylibrary')
           . ' AND ' .   $db->nameQuote('folder')  . ' = ' . $db->Quote('library');
    $db->setQuery($query);
    if (!$db->query()) {
        echo '<p>'.JText::_('NIE UDAO SI UDOSTPNI WYMAGANEGO MODUU DODATKOWEGO MY LIBRARY').'</p>';
    } else {
        echo '<p>'.JText::_('WYMAGANE ROZSZERZENIE MY LIBRARY ZOSTAO UDOSTPNIONE').'</p>';
    }
    
    // wszystko gotowe!
    return true;
}

?>
