package com.journaler.api.controller

import com.journaler.api.data.Note
import com.journaler.api.service.NoteService
import org.springframework.http.MediaType
import org.springframework.web.bind.annotation.*
import org.springframework.beans.factory.annotation.Autowired

@RestController
@RequestMapping("/notes")
class NoteController {
  @Autowired
  private lateinit var service: NoteService

  /**
   * Pobranie notatek.
   */
  @GetMapping(
    produces = arrayOf(MediaType.APPLICATION_JSON_VALUE)
  )
  fun getNotes() = service.getNotes()

  /**
   * Dodanie notatki.
   * Metoda odbiera dane, tj. treść notatki, w formacie JSON.
   */
  @PutMapping(
    produces = arrayOf(MediaType.APPLICATION_JSON_VALUE),
    consumes = arrayOf(MediaType.APPLICATION_JSON_VALUE)
  )
  fun insertNote(
    @RequestBody note: Note
  ) = service.insertNote(note)

  /**
   * Usunięcie notatki o zadanym identyfikatorze.
   * Ścieżka zawiera zmienną, której będzie przypisywany identyfikator notatki.
   */
  @DeleteMapping(
    value = "/{id}",
    produces = arrayOf(MediaType.APPLICATION_JSON_VALUE)
  )
  fun deleteNote(
    @PathVariable(name = "id") id: String
  ): Boolean = service.deleteNote(id)

  /**
   * Zmiana notatki.
   * Metoda odbiera dane, tj. treść notatki, w formacie JSON,
   * i zwraca wartość logiczną true po pomyślnym przetworzeniu.
   */
  @PostMapping(
    produces = arrayOf(MediaType.APPLICATION_JSON_VALUE),
    consumes = arrayOf(MediaType.APPLICATION_JSON_VALUE)
  )
  fun updateNote(
    @RequestBody note: Note
  ): Boolean = service.updateNote(note)
}