import {App} from '../../src/app';
import {StageComponent} from 'aurelia-testing';
import {bootstrap} from 'aurelia-bootstrapper';
 

// import {}'aurelia-testing', 'aurelia-bootstrapper'

describe('Testy klasy App', function () {
  var application;
  beforeAll(function () {
    application = new App();
  });
  it('właściwość message zawiera słowo "Wybierz"', function () {
    expect(application.message).toContain('Wybierz');
  });

  it('czy istnieje właściwość items', function () {
    expect(application.items).toBeDefined();
  });
  it('czy tablica items ma odpowiednią zawartość początkową', function () {
    expect(application.items.length).toBe(3);
  });
  it('czy w konstruktorze został ustawinona właściwość currentElement', function () {
    expect(application.currentElement).toBeDefined();
  });
  it('czy currentElement.idValue ma wartość 0', function () {
    expect(application.currentElement.idValue).toBe(0);
  });
  it('czy currentElement.displayName ma wartość none', function () {
    expect(application.currentElement.displayName).toBe('none');
  });
  describe("test elementów tablicy", function () {
    var item2;
    beforeAll(function () {
      item2 = application.items[1];
    });
    it('czy ma drugi element', function () {
      expect(item2).toBeDefined();
    });
    it('czy drugi element ma idValue o wartości 2', function () {
      expect(item2.idValue).toBe(2);
    });
    it('czy drugi element ma displaName o wartości secondItem', function () {
      expect(item2.displayName).toBe('secondItem');
    });
  });
});

//*

describe('Testy wyświetlania aplikacji', function () {
  var application;
  beforeEach(function () {
    application = StageComponent
      .withResources('app')
      .inView(
        '<require from="./ClickableItem"></require>' +
        '<h1 id="messageHeader">${message}</h1>' +
        '<ul id="ulItemList">' +
        '<li repeat.for="item of items" ' +
        'click.delegate="onItemClicked(item)">' +
        '<button id="select_button_${$index}">' + 
        '${item.displayName}</button>' +
        '</li>' +
        '</ul>' +
        '<clickable-item id-value="${currentElement.idValue}" ' +
        ' display-name="${currentElement.displayName}" ' +
        ' ></clickable-item>')
      .boundTo(new App());
  });
  it('powinien wyświetlić wartość właściwości message', (done) => {
    application.create(bootstrap).then( () => {
      var messageHeader = document.querySelector('#messageHeader');
      expect(messageHeader).toBeDefined();
      expect(messageHeader.innerHTML).toContain('Wybierz');
      done();
    });
  });
  it('powinien wyświetlić przyciski', (done) => {
    application.create(bootstrap).then( () => {
      var ulItemList = document.querySelectorAll(
        '#ulItemList > li > button');
      expect(ulItemList).toBeDefined();
      for (var i = 0; i < ulItemList.length; i++) {
        var itemElement = ulItemList[i];
        expect(itemElement.innerHTML).toContain('Element');
      }
      done();
    });
  });
  it('powinien wyświetlić "none" jako wybrany element', (done) => {
    application.create(bootstrap).then( () => {
      var clickableItem = document.querySelector('clickable-item');
      console.log(document);
      console.log(clickableItem.innerHTML);
      expect(clickableItem.innerHTML).toContain('none');
      done();
    });
  });
  afterEach(function () {
    application.dispose();
  });

  //*/

});
