import {HttpClient} from 'aurelia-http-client';
import {EventAggregator} from 'aurelia-event-aggregator';
import {inject} from 'aurelia-framework';

@inject(EventAggregator)
export class Login {
  header = 'Proszę się zalogować';
  userName = "";
  password = "";
  
  ea: EventAggregator;
  constructor(EventAggregator) {
    this.ea = EventAggregator;
  }

  onSubmit() {
    var postMessage = { 
        userName: this.userName, 
        password : this.password };
    //console.log(`Login.ts użytkownik : ${this.userName}, hasło : ${this.password}`);
    //console.log(`postMessage : ${postMessage}`);

    let client = new HttpClient();
    client.post('/login', postMessage)
      .then( (message) => {
        console.log(`zwrócone dane POST : ${message.response}`);
        this.ea.publish('login_result', {success: true});
      })
      .catch( (err) => {
        console.log(`err.response: ${err.response}`);
      });
  }
}