/*
function doCalculation(a,b,c) {
  return (a * b) + c;
}
var result = doCalculation(2,3,1);
console.log('doCalculation():' + result);
//*/

function doCalculation(
  a : number,
  b : number,
  c : number) {
  return ( a * b ) + c;
}

var result = doCalculation(3,2,1);
console.log("doCalculation():" + result);

//-- błędy: nieprawidłowe typy argumentów
//var result = doCalculation("2","3","1");  
//console.log('doCalculation():' + result);

var myString : string;
var myNumber : number;
var myBoolean : boolean;
myString = "1";
myNumber = 1;
myBoolean = true;

//-- błęd nieprawidłowych typów
// myString = myNumber;   
// myBoolean = myString;
// myNumber = myBoolean;

var inferredString = "to jest łańcuch znaków";
var inferredNumber = 1;
// inferredString = inferredNumber;    //-- błąd: wnioskowanie typów

var complexType = { name: "mojeImię", id: 1 };
complexType = { id: 2, name: "inneImię" };

var complexType = { name: "myName", id: 1 };
//complexType = { id: 2 };  //-- błąd: za mało właściwości

var complexType = { name: "mojeImię", id: 1 };
//complexType = { name: "imię", id: 2, extraProp: true };  //-- błąd: za dużo właściwości

var arrayOfNumbers: number[] = [1, 2, 3];
arrayOfNumbers = [3,4,5,6,7,8,9];
console.log(`arrayOfNumbers: ${arrayOfNumbers}`);
// arrayOfNumbers = ["1", "2", "3"];  //-- błąd: tablica niewłaściwego typu


var arrayOfStrings : string[] = ["pierwszy", "drugi", "trzeci"];
for( var i = 0; i < arrayOfStrings.length; i++ ) {
  console.log(`arrayOfStrings[${i}] = ${arrayOfStrings[i]}`);
}


for( var itemKey in arrayOfStrings) {
  var itemValue = arrayOfStrings[itemKey];
  console.log(`arrayOfStrings[${itemKey}] = ${itemValue}`);
}

for( var arrayItem of arrayOfStrings ) {
  console.log(`arrayItem = ${arrayItem} `);
}

// typ any
// var item1 = { id: 1, name: "item 1" };
// item1 = { id: 2 };  //-- błąd: niezgodność typów

var item1 : any = { id: 1, name: "element 1" };
item1 = { id: 2 };

var item2 = <any>{ id: 1, name: "element 1" };
item2 = { id: 2 };

//*
enum DoorState {
    Open,
    Closed,
    Ajar
}
//*/

var openDoor = DoorState.Open;
console.log(`Wartość openDoor wynosi: ${openDoor}`);

var closedDoor = DoorState["Closed"];
console.log(`Wartość closedDoor wynosi: ${closedDoor}`);

var ajarDoor = DoorState[2];
console.log(`Wartość ajarDoor wynosi: ${ajarDoor}`);

/*
enum DoorState {
  Open = 3,
  Closed = 7,
  Ajar = 10
}
//*/

const enum DoorStateConst {
    Open,
    Closed,
    Ajar
}

var constDoorOpen = DoorStateConst.Open;
console.log(`Wartość constDoorOpen wynosi: ${constDoorOpen}`);

// console.log(`${DoorStateConst[0]}`);  // błąd

console.log(`${DoorStateConst["Open"]}`);  // ok

const constValue = "test";
// constValue = "updated";  // błąd: próba zmiany wartości stałej

console.log(`anyValue = ${anyValue}`);
var anyValue = 2;
console.log(`anyValue = ${anyValue}`);


// console.log(`letValue = ${lValue}`);  // błąd: próba użycia niezdefiniowanej zmiennej
// let lValue = 2;

// let lValue = 2;
// console.log(`lValue = ${lValue}`);

let lValue = 2;
console.log(`lValue = ${lValue}`);
if (lValue == 2) {
  let lValue = 2001;
  console.log(`zmienna blokowa lValue : ${lValue} `);
}
console.log(`lValue = ${lValue}`);

/*
function addNumbers(a: number, b: number) : string {
    return a + b;
}

var addResult = addNumbers(2,3);
console.log(`Wywołanie addNumbers zwróciło : ${addResult}`);
//*/

function addNumbers(a: number, b: number) : string {
  return (a + b).toString();
}

var addResult = addNumbers(2,3);
console.log(`Wywołanie addNumbers zwróciło : ${addResult}`);

// kod JavaScript
var addVar = function(a,b) {
  return a + b;
}

var addVarResult = addVar(2,3);
console.log("addVarResult:" + addVarResult);

// funkcja anonimowa w języku TypeScript
var addFunction = function(a:number, b:number) : number {
  return a + b;
}
var addFunctionResult = addFunction(2,3);
console.log(`addFunctionResult: ${addFunctionResult}`);

// parametry opcjonalne : kod JavaScript
// var concatStrings = function(a,b,c) {
//   return a + b + c;
// }

// var concatAbc = concatStrings("a", "b", "c");
// console.log("concatAbc :" + concatAbc);

// var concatAb = concatStrings("a", "b"); // błąd w TypeScripcie - za mało argumentów
// console.log("concatAb :" + concatAb); 


function concatStrings( a: string, b: string, c?: string) {
  return a + b + c;
}

var concat3strings = concatStrings("a", "b", "c");
console.log(`concat3strings : ${concat3strings}`);
var concat2strings = concatStrings("a", "b");
console.log(`concat2strings : ${concat2strings}`);
// var concat1string = concatStrings("a");  // błąd: wywołanie nie pasuje do sygnatury



// wartości domyślne
function concatStringsDefault(
  a: string,
  b: string,
  c: string = "c") {
    return a + b + c;
}
var defaultConcat = concatStringsDefault("a", "b");
console.log(`defaultConcat : ${defaultConcat}`);

// zmienna arguments w języku JavaScript 
/*
function testArguments() {
    if (arguments.length > 0) {
        for (var i = 0; i < arguments.length; i++) {
            console.log("argument[" + i + "] = " + arguments[i]);
        }
    }
}
testArguments(1,2,3,4);
testArguments("pierwszy argument");

Wyniki:
argument[0] = 1
argument[1] = 2
argument[2] = 3
argument[3] = 4
argument[0] = pierwszy argument
//*/


function testArguments(... argArray: number []) {
  if (argArray.length > 0) {
    for (var i = 0; i < argArray.length; i++) {
      console.log(`argArray[${i}] = ${argArray[i]}`);
      // zastosowanie zmiennej arguments języka JavaScript
      console.log(`arguments[${i}] = ${arguments[i]}`)
    }
  }
}
testArguments(9);
testArguments(1,2,3);


// parametr reszty i normalne parametry funkcji
function testNormalAndRestArguments(
  arg1: string,
  arg2, number,
  ...argArray: number[]
) {
}

// funkcje zwrotne, kod JavaScript:
/*
var callbackFunction = function(text) {
  console.log('wewnątrz funkcji callbackFunction ' + text);
}
function doSomethingWithACallback( initialText, callback ) {
  console.log('wewnątrz funkcji doSomethingWithACallback ' + initialText);
  callback(initialText);
}

doSomethingWithACallback('jakiś tekst', callbackFunction);
//*/


/*
function doSomethingWithACallback( initialText, callback ) {
  console.log('wewnątrz funkcji doSomethingWithACallback ' + initialText);
  if (typeof callback === "function") {
    callback(initialText);
  } else {
    console.log(callback  + " nie jest funkcją!!");
  }
}

doSomethingWithACallback("jakiś tekst", "innyTekst");
//*/



// sygnatury funkcji w TypeScripcie
function callbackFunction(text: string) {
  console.log(`wewnątrz callbackFunction ${text}`);
}

function doSomethingWithACallback(
  initialText: string,
  callback : (initialText: string) => void
) {
  console.log(`wewnątrz doSomethingWithACallback ${initialText}`);
  callback(initialText);
}



doSomethingWithACallback("jakiś tekst", callbackFunction);

// doSomethingWithACallback("jakiś tekst", "toNieJestFunkcja");

/*
function callbackFunctionWithNumber(arg1: number) {
  console.log(`wewnątrz callbackFunctionWithNumber ${arg1}`)
}
doSomethingWithACallback("jakiś tekst", callbackFunctionWithNumber);
//*/



// przeciążanie funkcji, kod JavaScript
/*
function add(x, y) {
    return x + y;
}

console.log('add(1,1)=' + add(1,1));
console.log('add("1","1")=' + add("1","1"));
//*/

function add(a: string, b: string) : string;
function add(a: number, b:number) : number;
function add(a: any, b: any): any {
  return a + b;
}

console.log(`add(1,1)= ${add(1,1)}`);
console.log(`add("1","1")= ${add("1","1")}`);


// console.log(`add(true,false)= ${ add(true,false)}`); // bład: nieprawidłowy typ argumentów


var unionType : string | number;

unionType = 1;
console.log(`unionType : ${unionType}`);

unionType = "test";
console.log(`unionType : ${unionType}`);

// strażniki typów
/*
function addWithUnion(
  arg1 : string | number,
  arg2 : string | number
) {
  return arg1 + arg2;  // błąd: brak możliwości określenia typu 
}
//*/



// strażniki typów
function addWithTypeGuard(
  arg1 : string | number,
  arg2 : string | number
) : string | number {
  if( typeof arg1 ==="string") {
    // w tym kodzie arg1 jest traktowany jako łańcuch znaków
    console.log('pierwszy argument jest łańcuchem');
    return arg1 + arg2;
  }
  if (typeof arg1 === "number" && typeof arg2 === "number") {
    // w tym kodzie arg1 i arg2 są traktowane jako liczby
    console.log('oba argumenty są liczbami');
    return arg1 + arg2;
  }
  console.log('domyślny sposób wyznaczenia wyniku');
  return arg1.toString() + arg2.toString();
}

console.log(`addWithTypeGuard(1,2)= ${addWithTypeGuard(1,2)}`);


console.log(`addWithTypeGuard("1","2")= ${addWithTypeGuard("1","2")}`);

console.log(`addWithTypeGuard(1,"2") = ${addWithTypeGuard(1,"2")}`);

// nazwy zastępcze (aliasy) typów

type StringOrNumber = string | number;

function addWithAliases(
    arg1: StringOrNumber,
    arg2: StringOrNumber
) {
    return arg1.toString() + arg2.toString();
}

// wartości null i undefined

function testUndef(test : null | number) {
  console.log('parametr test: ' + test);
}

// testUndef(); // błąd: wywołanie funkcji bez argumentów

let x : number | null;

x = 1;
x = undefined;
x = null;

// reszta obiektu i rozproszenie

let firstObj = { id: 1, name : "firstObj"};

let secondObj = { ...firstObj };
console.log(`secondObj.id : ${secondObj.id}`);
console.log(`secondObj.name : ${secondObj.name}`);

let nameObj = { name : "nameObj"};
let idObj = { id : 2};
let obj3 = { ...nameObj, ...idObj };

console.log(`obj3.id : ${obj3.id}`);
console.log(`obj3.name : ${obj3.name}`);

