#
#	NearestPoint
#
#	Majc dany punkt i lini wyszukuje na tej linii punkt znajdujcy si
#	najbliej tego punktu.
#

nearestPoint <- function(...) {
}

#
# **  Zastosowanie:
# **      point_line_distance(x1,y1,x2,y2,ptx,pty)
# **
# **  Argumenty:
# **      intercept  punkt przecicia linii z osi wsprzdnych
# **      slope      nachylenie linii
# **      ptx,pty    punkt, z ktrego nastpuje pomiar
# **
# **  Zwraca:
# **      odlego od danego punktu do danej linii
# **
# **  GMLscripts.com
#
nearest_point <- function(ptx, pty, intercept, slope) {

    N <- length(ptx)
    stopifnot(length(pty) == N)

    # Za pomoc nachylenie i punktu przecicia z osi wsprzdnych wyznacza
    # dwa punkty na linii
    #
    x1 <- 0
    y1 <- intercept
    x2 <- 1
    y2 <- intercept + slope

    dx = rep(x2 - x1, N)
    dy = rep(y2 - y1, N)

    # Naley sprawdzi: Czy punkt = dany punkt?
    #
    t <- ifelse(dx == 0 & dy == 0,
			0,
			((ptx - x1) * dx + (pty - y1) * dy) / (dx * dx + dy * dy) )

    x = x1 + t * dx;
    y = y1 + t * dy;

    nearest <- cbind(x,y)
    colnames(nearest) <- c("x", "y")
    return(nearest)
}

point_distance <- function(x0, y0, x1, y1) {
	sqrt((x1-x0)^2 + (y1-y0)^2)
}

point_line_distance <- function(ptx, pty, intercept, slope) {
	nearest <- nearest_point(ptx, pty, intercept, slope)
	point_distance(ptx, pty, nearest[,"x"], nearest[,"y"])
}
