
chunk <- "```"
inline <- function(x = "") paste0("`` `r ", x, "` ``")
library(tidyverse)

mtcars[1:5, ]

knitr::kable(
  mtcars[1:5, ], 
  caption = "A knitr kable."
)

`r chunk`{r raw_data}
rawdata <- readr::read_csv("a_very_large_file.csv")
`r chunk`

`r chunk`{r processed_data, cache = TRUE}
processed_data <- rawdata %>% 
  filter(!is.na(import_var)) %>% 
  mutate(new_variable = complicated_transformation(x, y, z))
`r chunk`


`r chunk`{r processed_data, cache = TRUE, dependson = "raw_data"}
processed_data <- rawdata %>% 
  filter(!is.na(import_var)) %>% 
  mutate(new_variable = complicated_transformation(x, y, z))
`r chunk`


`r chunk`{r raw_data, cache.extra = file.info("a_very_large_file.csv")}
rawdata <- readr::read_csv("a_very_large_file.csv")
`r chunk`


knitr::opts_chunk$set(
  comment = "#>",
  collapse = TRUE
)

knitr::opts_chunk$set(
  echo = FALSE
)

comma <- function(x) format(x, digits = 2, big.mark = ",")
comma(3452345)
comma(.12358124331)

params:
  start: !r lubridate::ymd("2015-01-01")
snapshot: !r lubridate::ymd_hms("2015-01-01 12:30:00")

rmarkdown::render("fuel-economy.Rmd", params = list(my_class = "suv"))

reports <- tibble(
  class = unique(mpg$class),
  filename = stringr::str_c("fuel-economy-", class, ".html"),
  params = purrr::map(class, ~ list(my_class = .))
)
reports

reports %>% 
  select(output_file = filename, params) %>% 
  purrr::pwalk(rmarkdown::render, input = "fuel-economy.Rmd")

bibliography: rmarkdown.bib

bibliography: rmarkdown.bib
csl: apa.csl
