
library(tidyverse)
library(stringr)

string1 <- "To jest napis"
string2 <- 'Aby umieścić "cytat" wewnątrz napisu, użyj pojedynczych cudzysłowów'


double_quote <- "\"" # or '"'
single_quote <- '\'' # lub "'"

x <- c("\"", "\\")
x
writeLines(x)

x <- "\u00b5"
x

c("raz", "dwa", "trzy")

str_length(c("a", "R w analizie danych", NA))

str_c("x", "y")
str_c("x", "y", "z")

str_c("x", "y", sep = ", ")

x <- c("abc", NA)
str_c("|-", x, "-|")
str_c("|-", str_replace_na(x), "-|")

str_c("prefix-", c("a", "b", "c"), "-suffix")

name <- "Hadley"
time_of_day <- "wieczór"
birthday <- FALSE

str_c(
  "Dobry ", time_of_day, " ", name,
  if (birthday) " i 100 LAT!",
  "."
)

str_c(c("x", "y", "z"), collapse = ", ")

x <- c("Jabłko", "Banan", "Gruszka")
str_sub(x, 1, 3)

# liczby ujemne liczą się od końca
str_sub(x, -3, -1)

str_sub("a", 1, 5)

str_sub(x, 1, 1) <- str_to_lower(str_sub(x, 1, 1))
x

# W języku tureckim stosowane są dwie litery i: z kropką i bez
# dla każdej z nich istnieją inne reguły przekształcania w wielką literę: 
str_to_upper(c("i", "ı"))
str_to_upper(c("i", "ı"), locale = "tr")

x <- c("ananas", "endywia", "banan")

str_sort(x, locale = "en")  # angielski

str_sort(x, locale = "haw") # hawajski 

x <- c("jabłko", "banan", "gruszka")
str_view(x, "an")

str_view(x, ".a.")

# Aby utworzyć wyrażenie regularne, potrzebujemy znaków \\
dot <- "\\."

# Ale samo wyrażenie zawiera tylko jeden taki znak:
writeLines(dot)

# Który jawnie informuje R, aby szukać znaku kropki .
str_view(c("abc", "a.c", "bef"), "a\\.c")

x <- "a\\b"
writeLines(x)

str_view(x, "\\\\")

x <- c("ananas", "banan", "gruszka")
str_view(x, "^a")
str_view(x, "a$")

x <- c("jabłko pieczone", "jabłko", "jabłko w cieście")
str_view(x, "jabłko")
str_view(x, "^jabłko$")

str_view(c("grey", "gray"), "gr(e|a)y")

x <- "1888 jest najdłuższym rokiem, zapisanym cyframi rzymskimi: MDCCCLXXXVIII"
str_view(x, "CC?")
str_view(x, "CC+")
str_view(x, 'C[LX]+')

str_view(x, "C{2}")
str_view(x, "C{2,}")
str_view(x, "C{2,3}")

str_view(x, 'C{2,3}?')
str_view(x, 'C[LX]+?')

str_view(fruit, "(..)\\1", match = TRUE)

x <- c("ananas", "banan", "gruszka")
str_detect(x, "e")

# Ile popularnych wyrazów zaczyna się od t?
sum(str_detect(words, "^t"))
# Jaki odsetek popularnych słów kończy się samogłoską?
mean(str_detect(words, "[aeiou]$"))

# Znajdź wszystkie słowa zawierające co najmniej jedną samogłoskę, i zaneguj wynik
no_vowels_1 <- !str_detect(words, "[aeiou]")
# Znajdź wszystkie słowa zawierające tylko spółgłoski (nie samogłoski)
no_vowels_2 <- str_detect(words, "^[^aeiou]+$")
identical(no_vowels_1, no_vowels_2)

words[str_detect(words, "x$")]
str_subset(words, "x$")

df <- tibble(
  word = words, 
  i = seq_along(word)
)
df %>% 
  filter(str_detect(words, "x$"))

x <- c("jabłko", "banan", "gruszka")
str_count(x, "a")

# Ile średnio samogłosek znajduje się w słowie?
mean(str_count(words, "[aeiou]"))

df %>% 
  mutate(
    vowels = str_count(word, "[aeiou]"),
    consonants = str_count(word, "[^aeiou]")
  )

str_count("abababa", "aba")
str_view_all("abababa", "aba")

length(sentences)
head(sentences)

colours <- c("red", "orange", "yellow", "green", "blue", "purple")
colour_match <- str_c(colours, collapse = "|")
colour_match

has_colour <- str_subset(sentences, colour_match)
matches <- str_extract(has_colour, colour_match)
head(matches)

more <- sentences[str_count(sentences, colour_match) > 1]
str_view_all(more, colour_match)

str_extract(more, colour_match)

str_extract_all(more, colour_match)

str_extract_all(more, colour_match, simplify = TRUE)

x <- c("a", "a b", "a b c")
str_extract_all(x, "[a-z]", simplify = TRUE)

noun <- "(a|the) ([^ ]+)"

has_noun <- sentences %>%
  str_subset(noun) %>%
  head(10)
has_noun %>% 
  str_extract(noun)

has_noun %>% 
  str_match(noun)

tibble(sentence = sentences) %>% 
  tidyr::extract(
    sentence, c("article", "noun"), "(a|the) ([^ ]+)", 
    remove = FALSE
  )

x <- c("jabłko", "gruszka", "banan")
str_replace(x, "[aeiou]", "-")
str_replace_all(x, "[aeiou]", "-")

x <- c("1 dom", "2 samochody", "3 ludzi")
str_replace_all(x, c("1" = "jeden", "2" = "dwa", "3" = "troje"))

sentences %>% 
  str_replace("([^ ]+) ([^ ]+) ([^ ]+)", "\\1 \\3 \\2") %>% 
  head(5)

sentences %>%
  head(5) %>% 
  str_split(" ")

"a|b|c|d" %>% 
  str_split("\\|") %>% 
  .[[1]]

sentences %>%
  head(5) %>% 
  str_split(" ", simplify = TRUE)

fields <- c("Nazwisko: Hadley", "Kraj: NZ", "Wiek: 35")
fields %>% str_split(": ", n = 2, simplify = TRUE)

x <- "To jest zdanie.  To jest inne zdanie."
str_view_all(x, boundary("word"))

str_split(x, " ")[[1]]
str_split(x, boundary("word"))[[1]]

# Zwykłe wywołanie:
str_view(fruit, "nana")
# jest skrótem takiego wywołania
str_view(fruit, regex("nana"))

bananas <- c("banan", "Banan", "BANAN")
str_view(bananas, "banan")
str_view(bananas, regex("banan", ignore_case = TRUE))

x <- "Wiersz 1\nWiersz 2\nWiersz 3"
str_extract_all(x, "^Wiersz")[[1]]
str_extract_all(x, regex("^Wiersz", multiline = TRUE))[[1]]

phone <- regex("
               \\(?     # opcjonalny nawias otwierający
               (\\d{3}) # numer kierunkowy
               [)- ]?   # opcjonalny nawias zamykający, kreska lub spacja 
               (\\d{3}) # kolejne trzy cyfry
               [ -]?    # opcjonalna spacja lub kreska 
               (\\d{3}) # kolejne trzy cyfry
               ", comments = TRUE)

str_match("514-791-8141", phone)

microbenchmark::microbenchmark(
  fixed = str_detect(sentences, fixed("the")),
  regex = str_detect(sentences, "the"),
  times = 20
)

a1 <- "\u00e1"
a2 <- "a\u0301"
c(a1, a2)
a1 == a2

str_detect(a1, fixed(a2))
str_detect(a1, coll(a2))

# Oznacza to, że musimy pamiętać o różnicach 
# dopasowując znaki bez uwzględniania wielkości liter:
i <- c("I", "İ", "i", "ı")
i

str_subset(i, coll("i", ignore_case = TRUE))
str_subset(i, coll("i", ignore_case = TRUE, locale = "tr"))

stringi::stri_locale_info()

x <- "To jest zdanie."
str_view_all(x, boundary("word"))
str_extract_all(x, boundary("word"))

apropos("replace")

head(dir(pattern = "\\.Rmd$"))
