// Program sterowany przez menu, który wywołuje funkcje
// w zależności od wyborów użytkownika.
#include <iostream>
#include <iomanip>
using namespace std;

// Prototypy funkcji
void showMenu();
void showFees(double, int);

int main()
{
   int choice;       // Przechowywanie wyborów z menu
   int months;       // Przechowywanie liczby miesięcy

   // Stałe dla pozycji menu
   const int ADULT_CHOICE = 1,
             CHILD_CHOICE = 2,
             SENIOR_CHOICE = 3,
             QUIT_CHOICE = 4;

   // Stałe dla opłat za karnety
   const double ADULT = 40.0,
                SENIOR = 30.0,
                CHILD = 20.0;

   // Ustawienie formatowania liczb na wyjściu
   cout << fixed << showpoint << setprecision(2);

   do
   {
      // Wyświetlenie menu i odczytanie wejścia od użytkownika
      showMenu();
      cin >> choice;

      // Walidacja wyboru
      while (choice < ADULT_CHOICE || choice > QUIT_CHOICE)
{
         cout << "Wybierz istniejącą pozycję z menu: ";
         cin >> choice;
      }

      // Przejście dalej, jeżeli użytkownik nie chce wyjść
      if (choice != QUIT_CHOICE)
      {
          // Pobranie liczby miesięcy
          cout << "Na ile miesięcy? ";
          cin >> months;

          // Wyświetlenie opłaty za karnet
          switch (choice)
          {
             case ADULT_CHOICE:  
                  showFees(ADULT, months);
                  break;
             case CHILD_CHOICE:
                  showFees(CHILD, months);
                  break;
             case SENIOR_CHOICE:
                  showFees(SENIOR, months);
          }
      }
   } while (choice != QUIT_CHOICE);
   return 0;
}

//*****************************************************************
// Definicja funkcji showMenu(), która wyświetla menu.              *
//*****************************************************************

void showMenu()
{
    cout << "\t\tMenu wyboru karnetów w klubie fitness\n\n"
         << "1. Standardowy, osoba dorosła\n"
         << "2. Dziecięcy\n"
         << "3. Dla seniora\n"
         << "4. Wyjdź z programu\n\n"
         << "Wprowadź swój wybór: ";
}

//*****************************************************************
// Definicja funkcji showFees(). Parametr memberRate zawiera        *
// miesięczną opłatę za karnet, a parametr months liczbę         *
// miesięcy. Funkcja wyświetla całkowitą cenę karnetu.            *
//*****************************************************************

void showFees(double memberRate, int months)
{
    cout << "Opłata całkowita wynosi "
         << (memberRate * months) << " zł."<< endl;
}
