#ifndef BINARYTREE_H
#define BINARYTREE_H
#include <iostream>
using namespace std;

// Szablon klasy BinaryTree
template <class T>
class BinaryTree
{
private:
  struct TreeNode
  {
    T value;           // Warto przechowywana w wle
    TreeNode *left;    // Wskanik do lewego wza pochodnego
    TreeNode *right;   // Wskanik do prawego wza pochodnego
  };

  TreeNode *root; // Wskanik do wza gwnego

  // Prywatne funkcje czonkowskie
  void insert(TreeNode *&, TreeNode *&);
  void destroySubTree(TreeNode *);
  void deleteNode(T, TreeNode *&);
  void makeDeletion(TreeNode *&);
  void displayInOrder(TreeNode *) const;
  void displayPreOrder(TreeNode *) const;
  void displayPostOrder(TreeNode *) const;

public:
  // Konstruktor
  BinaryTree()
    { root = nullptr; }

  // Destruktor
  ~BinaryTree()
    { destroySubTree(root); }

  // Operacje na drzewie binarnym
  void insertNode(T);
  bool searchNode(T);
  void remove(T);

  void displayInOrder() const
    { displayInOrder(root); }

  void displayPreOrder() const
    { displayPreOrder(root); }

  void displayPostOrder() const
    { displayPostOrder(root); }
};

//*************************************************************
// Funkcja insert() wstawia w drzewie wskazywanym w argumencie
// nodePtr wze wskazywany w argumencie newNode.
// Funkcja jest wywoywana rekurencyjne.
//*************************************************************
template <class T>
void BinaryTree<T>::insert(TreeNode *&nodePtr, TreeNode *&newNode)
{
  if (nodePtr == nullptr)
    nodePtr = newNode;               // Wstawienie wza
  else if (newNode->value < nodePtr->value)
    insert(nodePtr->left, newNode);  // Przeszukanie lewego poddrzewa
  else
    insert(nodePtr->right, newNode); // Przeszukanie prawego poddrzewa
}

//***********************************************************
// Funkcja insertNode() tworzy nowy wze, zapisuje w jego zmiennej value
// warto argumentu num i umieszcza go w argumencie funkcji insert().
//***********************************************************
template <class T>
void BinaryTree<T>::insertNode(T item)
{
  TreeNode *newNode = nullptr;  // Wskanik nowego wza

  // Utworzenie nowego wza i zapisanie w nim argumentu num
  newNode = new TreeNode;
  newNode->value = item;
  newNode->left = newNode->right = nullptr;

  // Wstawienie wza
  insert(root, newNode);
}

//***************************************************
// Funkcja destroySubTree() wywoywana przez destruktor,
// usuwa wszystkie wzy drzewa.
//***************************************************
template <class T>
void BinaryTree<T>::destroySubTree(TreeNode *nodePtr)
{
  if (nodePtr)
  {
    if (nodePtr->left)
      destroySubTree(nodePtr->left);
    if (nodePtr->right)
      destroySubTree(nodePtr->right);
    delete nodePtr;
  }
}

//***************************************************
// Funkcja searchNode() zwraca wynik true, jeeli
// szukana warto jest zapisana w drzewie, lub false
// w przeciwnym razie.
//***************************************************
template <class T>
bool BinaryTree<T>::searchNode(T item)
{
  TreeNode *nodePtr = root;

  while (nodePtr)
  {
    if (nodePtr->value == item)
      return true;
    else if (item < nodePtr->value)
      nodePtr = nodePtr->left;
    else
      nodePtr = nodePtr->right;
  }
  return false;
}

//***********************************************
// Funkcja remove() wywouje funkcj deleteNode() w celu usunicia
// wza zawierajcego warto podan w argumencie num.
//***********************************************
template <class T>
void BinaryTree<T>::remove(T item)
{
  deleteNode(item, root);
}

//********************************************
// Funkcja deleteNode() usuwa wze, ktrego zmienna value
// zawiera warto podan w argumencie num.
//********************************************
template <class T>
void BinaryTree<T>::deleteNode(T item, TreeNode *&nodePtr)
{
  if (item < nodePtr->value)
    deleteNode(item, nodePtr->left);
  else if (item > nodePtr->value)
    deleteNode(item, nodePtr->right);
  else
    makeDeletion(nodePtr);
}

//***********************************************************
// Funkcja makeDeletion() usuwajca wze, ktrego referencja
// jest podana w argumencie. Funkcja po usuniciu wza
// przycza z powrotem poddrzewa.
//***********************************************************
template <class T>
void BinaryTree<T>::makeDeletion(TreeNode *&nodePtr)
{
  // Definicja tymczasowego wskanika wykorzystywanego
  // do przyczenia lewego poddrzewa
  TreeNode *tempNodePtr = nullptr;

  if (nodePtr == nullptr)
    cout << "Nie mona usun pustego wza.\n";
  else if (nodePtr->right == nullptr)
  {
    tempNodePtr = nodePtr;
    nodePtr = nodePtr->left;   // Przyczenie lewego poddrzewa
    delete tempNodePtr;
  }
  else if (nodePtr->left == nullptr)
  {
    tempNodePtr = nodePtr;
    nodePtr = nodePtr->right;  // Przyczenie prawego poddrzewa
    delete tempNodePtr;
  }
  // Jeeli wze ma dwa wzy pochodne
  else
  {
    // Przeniesienie jednego wza do prawego poddrzewa
    tempNodePtr = nodePtr->right;
    // Przejcie na koniec lewego poddrzewa
    while (tempNodePtr->left)
      tempNodePtr = tempNodePtr->left;
    // Przyczenie lewego poddrzewa
    tempNodePtr->left = nodePtr->left;
    tempNodePtr = nodePtr;
    // Przyczenie prawego poddrzewa
    nodePtr = nodePtr->right;
    delete tempNodePtr;
  }
}

//*************************************************************
// Funkcja displayInOrder() wywietla w przejciu poprzecznym
// wartoci zawarte w drzewie wskazywanym przez nodePtr.
//*************************************************************
template <class T>
void BinaryTree<T>::displayInOrder(TreeNode *nodePtr) const
{
  if (nodePtr)
  {
    displayInOrder(nodePtr->left);
    cout << nodePtr->value << endl;
    displayInOrder(nodePtr->right);
  }
}

//*************************************************************
// Funkcja displayPreOrder() wywietla w przejciu wzdunym
// wartoci zawarte w drzewie wskazywanym przez nodePtr.
//*************************************************************
template <class T>
void BinaryTree<T>::displayPreOrder(TreeNode *nodePtr) const
{
  if (nodePtr)
  {
    cout << nodePtr->value << endl;
    displayPreOrder(nodePtr->left);
    displayPreOrder(nodePtr->right);
  }
}

//*************************************************************
// Funkcja displayPostOrder() wywietla w przejciu wstecznym
// wartoci zawarte w drzewie wskazywanym przez nodePtr.
//*************************************************************
template <class T>
void BinaryTree<T>::displayPostOrder(TreeNode *nodePtr) const
{
  if (nodePtr)
  {
    displayPostOrder(nodePtr->left);
    displayPostOrder(nodePtr->right);
    cout << nodePtr->value << endl;
  }
}
#endif
