// Plik implementacji klasy NumberList
#include <iostream>  // Plik wymagany przez strumie cout
#include "NumberList.h"
using namespace std;

//**************************************************
// Funkcja appendNode() docza na kocu listy
// wze z zwartoci podan w argumencie num.
//**************************************************

void NumberList::appendNode(double num)
{
  ListNode *newNode;  // Zmienna wskazujca nowy wze
  ListNode *nodePtr;  // Zmienna do przegldania listy

  // Utworzenie nowego wza i zapisanie w nim liczby
   newNode = new ListNode;
   newNode->value = num;
   newNode->next = nullptr;

  // Jeeli lista nie zawiera wzw,
  // jako pierwszy wstawiany jest newNode.
  if (!head)
    head = newNode;
  else  // W przeciwnym razie zmienna newNode umieszczana jest na kocu listy.
  {
    // Ustawienie wskanika nodePtr na pocztku listy
    nodePtr = head;

    // Wyszukanie ostatniego wza listy
    while (nodePtr->next)
      nodePtr = nodePtr->next;

    // Wstawienie newNode jako ostatniego wza listy
      nodePtr->next = newNode;
   }
}

//**************************************************
// Funkcja displayList() wywietla wartoci
// zapisane we wszystkich wzach listy
// wskazywanej przez nagwek head.
//**************************************************

void NumberList::displayList() const
{
  ListNode *nodePtr;  // Zmienna do przegldania listy

  // Ustawienie wskanika nodePtr na pocztku listy
   nodePtr = head;

  // Przegldanie listy dopki
  // nodePtr wskazuje wze
  while (nodePtr)
  {
    // Wywietlenie zawartoci biecego wza
    cout << nodePtr->value << endl;

    // Przejcie do nastpnego wza
    nodePtr = nodePtr->next;
  }
}

//**************************************************
// Funkcja insertNode() wstawiajca nowy wze
// z wartoci podan w argumencie num
//**************************************************

void NumberList::insertNode(double num)
{
  ListNode *newNode;                // Wskanik nowego wza
  ListNode *nodePtr;                // Zmienna do przegldania listy
  ListNode *previousNode = nullptr;  // Wskanik poprzedniego wza

  // Utworzenie nowego wza i zapisanie w nim argumentu num
  newNode = new ListNode;
  newNode->value = num;
   
  // Jeeli lista nie zawiera wzw,
  // jako pierwszy wstawiany jest newNode
  if (!head)
  {
    head = newNode;
    newNode->next = nullptr;
  }
  else  // W przeciwnym razie zmienna newNode umieszczana jest na kocu listy
  {
    // Ustawienie wskanika nodePtr na pocztku listy
    nodePtr = head;

    // Zainicjowanie zmiennej previousNode wartoci nullptr
    previousNode = nullptr;

    // Pomicie wszystkich wzw zawierajcych warto mniejsz ni num
    while (nodePtr != nullptr && nodePtr->value < num)
    {  
      previousNode = nodePtr;
      nodePtr = nodePtr->next;
    }

    // Jeeli nowy wze ma by pierwszy w licie,
    // zostanie wstawiony przed wszystkimi wzami.
    if (previousNode == nullptr)
    {
       head = newNode;
       newNode->next = nodePtr;
    }
    else  // W przeciwnym razie zostanie wstawiony za poprzednim wzem
    {
       previousNode->next = newNode;
       newNode->next = nodePtr;
    }
  }
}

//**************************************************
// Funkcja deleteNode() wyszukuje wze zawierajcy
// warto rwn num. Jeeli wze zostanie znaleziony,
// jest usuwany z listy i pamici.
//**************************************************

void NumberList::deleteNode(double num)
{
  ListNode *nodePtr;       // Zmienna do przegldania listy
  ListNode *previousNode;  // Zmienna wskazujca poprzedni wze

  // Jeli lista jest pusta, nie rb nic
  if (!head)
    return;

  // Sprawdzenie, czy pierwszy wze to ten waciwy
  if (head->value == num)
  {
    nodePtr = head->next;
    delete head;
    head = nodePtr;
  }
  else
  {
    // Ustawienie wskanika nodePtr na pocztku listy
    nodePtr = head;

    // Pominicie wszystkich wzw, ktrych zmienna value
    // nie jest rwna num
    while (nodePtr != nullptr && nodePtr->value != num)
    {
      previousNode = nodePtr;
      nodePtr = nodePtr->next;
    }

    // Jeeli nodePtr nie wskazuje koca listy, poprzedni
    // wze jest czony z wzem znajdujcym si za nodePtr,
    // a nastpnie usuwany jest wze nodePtr.
    if (nodePtr)
    {
      previousNode->next = nodePtr->next;
      delete nodePtr;
    }
  }
}

//**************************************************
// Destruktor
// Usuwa wszystkie wzy listy.
//**************************************************

NumberList::~NumberList()
{
  ListNode *nodePtr;   // Zmienna do przegldania listy
  ListNode *nextNode;  // Zmienna wskazujca nastpny wze

  // Ustawienie wskanika nodePtr na pocztku listy
  nodePtr = head;

  // Dopki nodePtr nie wskazuje koca listy...
  while (nodePtr != nullptr)
  {
    // ...wskanik jest ustawiany na nastpnym wle, ...
    nextNode = nodePtr->next;

    // ...usuwany jest biecy wze, ...
    delete nodePtr;

    // ...zmienna nodePtr jest ustawiana na nastpnym wle.
    nodePtr = nextNode;
   }
}

//**************************************************
// Funkcja countNodes() jest funkcj rekurencyjn,
// zwracajc liczb wzw w licie.
//**************************************************

int NumberList::countNodes(ListNode *nodePtr) const
{
  if (nodePtr != nullptr)
    return 1 + countNodes(nodePtr->next);
  else
    return 0;
}

//****************************************************
// Funkcja showReverse() jest funkcj rekurencyjn wywietlajc
// w odwrotnej kolejnoci wartoci zapisane w wzach listy. Funkcja
// ta jest wywoywana przez funkcj DisplayBackwards().
//****************************************************

void NumberList::showReverse(ListNode *nodePtr) const
{
  if (nodePtr != nullptr)
  {
    showReverse(nodePtr->next);
    cout << nodePtr->value << " ";
  }
}