// Plik implementacji klasy Dealer
#include "Dealer.h"
#include "Die.h"
#include <string>
using namespace std;

//*******************************************
// Konstruktor
//*******************************************
Dealer::Dealer()
{
  // Ustawienie pocztkowej liczby oczek na 0
  // (Te wartoci nie bd wykorzystywane)
  die1Value = 0;
  die2Value = 0;
}

//*******************************************
// Funkcja rollDice() "rzuca" kostkami
// i zapisuje liczby oczek.
//*******************************************
void Dealer::rollDice()
{
  // Rzut kostkami
  die1.roll();
  die2.roll();

  // Zapisanie liczby oczek
  die1Value = die1.getValue();
  die2Value = die2.getValue();
}

//********************************************
// Funkcja getChoOrHan() zwraca wynik rzutu:
// Cho (liczba parzysta)
// lub Han (liczba nieparzysta).
//********************************************
string Dealer::getChoOrHan()
{
  string result; // Zmienna przechowujca wynik rzutu

  // Zsumowanie liczby oczek.
  int sum = die1Value + die2Value;

  // Sprawdzenie parzystoci / nieparzystoci wyniku
  if (sum % 2 == 0)
    result = "Cho (suma parzysta)";
  else
    result = "Han (suma nieparzysta)";

  // Zwrcenie wyniku
  return result;
}

//********************************************
// Funkcja getDie1Value() zwraca liczb oczek
// kostki nr 1.
//********************************************
int Dealer::getDie1Value()
{
  return die1Value;
}

//********************************************
// Funkcja getDie2Value() zwraca liczb oczek
// kostki nr 2.
//********************************************
int Dealer::getDie2Value()
{
  return die2Value;
}
