// Ten program demonstruje zastosowanie algorytmw
// sortowania przez wybieranie i wyszukiwania binarnego z wektorem.
#include <iostream>
#include <string>
#include <vector>
using namespace std;

// Prototyp funkcji
void selectionSort(vector<string>&);
void swap(string &, string &);
int binarySearch(const vector<string>&, string);

int main()
{
  string searchValue;  // Wyszukiwana warto
  int position;        // Pozycja znalezionej wartoci

  // Definicja wektora cigw znakw
  vector<string> names{ "Hanna", "Antoni", "Julia", "Jakub",
                        "Zuzanna", "Jan", "Maja", "Szymon",
                        "Zofia", "Franciszek", "Lena", "Filip" };

  // Posortowanie wektora
  selectionSort(names);

  // Wywietlenie elementw wektora
  cout << "Posortowane imiona:\n";
  for (auto element : names)
    cout << element << endl;
  cout << endl;

  // Wyszukiwanie imienia
  cout << "Podaj imi: ";
  getline(cin, searchValue);
  position = binarySearch(names, searchValue);

  // Wywietlenie wyniku
  if (position != -1)
    cout << "Pozycja szukanego imienia: " << position << "." << endl;
  else
    cout << "Imi nie zostao znalezione.\n";

  return 0;
}

//***********************************************************************
// Funkcja selectionSort() sortuje wektor cigw znakw w kolejnoci alfabetycznej.
//***********************************************************************
void selectionSort(vector<string> &v)
{
  int minIndex;
  string minValue;

  for (int start = 0; start < (v.size() - 1); start++)
  {
    minIndex = start;
    minValue = v[start];
    for (int index = start + 1; index < v.size(); index++)
    {
      if (v[index] < minValue)
      {
        minValue = v[index];
        minIndex = index;
      }
    }
    swap(v[minIndex], v[start]);
  }
}

//***************************************************
// Funkcja swap() zamienia miejscami cigi a i b.
//***************************************************
void swap(string &a, string &b)
{
  string temp = a;
  a = b;
  b = temp;
}

//*****************************************************************
// Funkcja binarySearch() wykorzystuje algorytm
// wyszukiwania binarnego do wyszukiwania w wektorze
// cigu podanego w argumencie str. Funkcja zwraca
// indeks elementu, jeeli cig znajduje si w wektorze,
// lub warto -1 w przeciwnym razie.
//*****************************************************************

int binarySearch(const vector<string> &v, string str)
{
  int first = 0,          // Indeks pierwszego elementu wektora
    last = v.size() - 1,  // Indeks ostatniego elementu wektora
    middle,               // Indeks rodkowego elementu wektora
    position = -1;        // Indeks szukanego cigu
  bool found = false;     // Flaga

  while (!found && first <= last)
  {
    middle = (first + last) / 2; // Wyliczenie indeksu rodkowego elementu wektora
    if (v[middle] == str)        // Szukany cig znajduje si w rodkowym elemencie wektora.
    {
      found = true;
      position = middle;
    }
    else if (v[middle] > str)    // Szukany cig znajduje si w pierwszej poowie wektora.
      last = middle - 1;
    else
      first = middle + 1;      // Szukany cig znajduje si w drugiej poowie wektora.
  }
  return position;
}
