// Plik implementacji klasy IntBinaryTree.cpp
#include <iostream>
#include "IntBinaryTree.h"
using namespace std;

//**************************************************************
// Funkcja insert() wstawiajca w drzewie wskazywanym w argumencie
// nodePtr wze wskazywany w argumencie newNode.
// Funkcja jest wywoywana rekurencyjne.
//**************************************************************

void IntBinaryTree::insert(TreeNode *&nodePtr, TreeNode *&newNode)
{
  if (nodePtr == nullptr)
    nodePtr = newNode;              // Wstawienie wza
  else if (newNode->value < nodePtr->value)
    insert(nodePtr->left, newNode); // Przeszukanie lewego poddrzewa
  else
    insert(nodePtr->right, newNode); // Przeszukanie prawego poddrzewa
}

//***********************************************************
// Funkcja insertNode() tworzy nowy wze, zapisuje w jego zmiennej value
// warto argumentu num i umieszcza go w argumencie funkcji insert().
//***********************************************************

void IntBinaryTree::insertNode(int num)
{
  TreeNode *newNode = nullptr;   // Wskanik nowego wza

  // Utworzenie nowego wza i zapisanie w nim argumentu num
  newNode = new TreeNode;
  newNode->value = num;
  newNode->left = newNode->right = nullptr;

  // Wstawienie wza
  insert(root, newNode);
}

//***************************************************
// Funkcja destroySubTree() wywoywana przez destruktor,
// usuwa wszystkie wzy drzewa.
//***************************************************

void IntBinaryTree::destroySubTree(TreeNode *nodePtr)
{
  if (nodePtr)
  {
    if (nodePtr->left)
      destroySubTree(nodePtr->left);
    if (nodePtr->right)
      destroySubTree(nodePtr->right);
    delete nodePtr;
  }
}

//*******************************************************
// Funkcja searchNode() zwraca wynik true, jeeli
// szukana warto jest zapisana w drzewie, lub false
// w przeciwnym razie.
//*******************************************************

bool IntBinaryTree::searchNode(int num)
{
  TreeNode *nodePtr = root;

  while (nodePtr)
  {
    if (nodePtr->value == num)
      return true;
    else if (num < nodePtr->value)
      nodePtr = nodePtr->left;
    else
      nodePtr = nodePtr->right;
  }
  return false;
}

//***********************************************
// Funkcja remove() wywouje funkcj deleteNode() w celu usunicia
// wza zawierajcego warto podan w argumencie num.
//***********************************************

void IntBinaryTree::remove(int num)
{
  deleteNode(num, root);
}


//********************************************
// Funkcja deleteNode() usuwa wze, ktrego zmienna value
// zawiera warto podan w argumencie num.
//********************************************

void IntBinaryTree::deleteNode(int num, TreeNode *&nodePtr)
{
  if (num < nodePtr->value)
    deleteNode(num, nodePtr->left);
  else if (num > nodePtr->value)
    deleteNode(num, nodePtr->right);
  else
    makeDeletion(nodePtr);
}


//***********************************************************
// Funkcja makeDeletion() usuwa wze, ktrego referencja
// jest podana w argumencie. Funkcja po usuniciu wza
// podcza z powrotem poddrzewa.
//***********************************************************

void IntBinaryTree::makeDeletion(TreeNode *&nodePtr)
{
  // Definicja tymczasowego wskanika wykorzystywanego
  // do przyczenia lewego poddrzewa
  TreeNode *tempNodePtr = nullptr;

  if (nodePtr == nullptr)
    cout << "Nie mona usun pustego wza.\n";
  else if (nodePtr->right == nullptr)
  {
    tempNodePtr = nodePtr;
    nodePtr = nodePtr->left;  // Przyczenie lewego poddrzewa
    delete tempNodePtr;
  }
  else if (nodePtr->left == nullptr)
  {
    tempNodePtr = nodePtr;
    nodePtr = nodePtr->right;  // Przyczenie prawego poddrzewa
    delete tempNodePtr;
  }
  // Jeeli wze ma dwa wzy pochodne
  else
  {
    // Przeniesienie jednego wza do prawego poddrzewa
    tempNodePtr = nodePtr->right;
    // Przejcie na koniec lewego poddrzewa
    while (tempNodePtr->left)
      tempNodePtr = tempNodePtr->left;
    // Przyczenie lewego poddrzewa
    tempNodePtr->left = nodePtr->left;
    tempNodePtr = nodePtr;
    // Przyczenie prawego poddrzewa
    nodePtr = nodePtr->right;
    delete tempNodePtr;
  }
}

//************************************************************
// Funkcja displayInOrder() wywietla w przejciu poprzecznym
// wartoci zawarte w drzewie wskazywanym przez nodePtr.
//************************************************************

void IntBinaryTree::displayInOrder(TreeNode *nodePtr) const
{
  if (nodePtr)
  {
    displayInOrder(nodePtr->left);
    cout << nodePtr->value << endl;
    displayInOrder(nodePtr->right);
  }
}

//*************************************************************
// Funkcja displayPreOrder() wywietla w przejciu wzdunym
// wartoci zawarte w drzewie wskazywanym przez nodePtr.
//*************************************************************

void IntBinaryTree::displayPreOrder(TreeNode *nodePtr) const
{
  if (nodePtr)
  {
    cout << nodePtr->value << endl;
    displayPreOrder(nodePtr->left);
    displayPreOrder(nodePtr->right);
  }
}

//*************************************************************
// Funkcja displayPostOrder() wywietla w przejciu wstecznym
// wartoci zawarte w drzewie wskazywanym przez nodePtr.
//*************************************************************

void IntBinaryTree::displayPostOrder(TreeNode *nodePtr) const
{
  if (nodePtr)
  {
    displayPostOrder(nodePtr->left);
    displayPostOrder(nodePtr->right);
    cout << nodePtr->value << endl;
  }
}
