﻿#ifndef QUEUE_H
#define QUEUE_H
#include <iostream>
using namespace std;

// Szablon klasy kolejki
template <class T>
class Queue
{
private:
  T * queueArray; // Wskaźnik tablicy wykorzystywanej przez kolejkę
  int queueSize;  // Wielkość kolejki
  int front;      // Indeks początku kolejki
  int rear;       // Indeks końca kolejki
  int numItems;   // Liczba elementów w kolejce
public:
  // Konstruktor
  Queue(int);

  // Konstruktor kopiujący
  Queue(const Queue &);

  // Destruktor.
  ~Queue();

  // Operacje wykonywane na kolejce
  void enqueue(T);
  void dequeue(T &);
  bool isEmpty() const;
  bool isFull() const;
  void clear();
};

//**************************************************************
// Ten konstruktor klasy tworzy pustą kolejkę o zadanej wielkości.
//**************************************************************
template <class T>
Queue<T>::Queue(int s)
{
  queueArray = new T[s];
  queueSize = s;
  front = -1;
  rear = -1;
  numItems = 0;
}

//**************************************************************
// Konstruktor kopiujący
//**************************************************************
template <class T>
Queue<T>::Queue(const Queue &obj)
{
  // Utworzenie tablicy wykorzystywanej przez kolejkę
  queueArray = new T[obj.queueSize];

  // Skopiowanie zmiennych członkowskich obiektu źródłowego
  queueSize = obj.queueSize;
  front = obj.front;
  rear = obj.rear;
  numItems = obj.numItems;

  // Skopiowanie tablicy wykorzystywanej przez kolejkę
  for (int count = 0; count < obj.queueSize; count++)
    queueArray[count] = obj.queueArray[count];
}

//**************************************************************
// Destruktor
//**************************************************************
template <class T>
Queue<T>::~Queue()
{
  delete[] queueArray;
}

//**************************************************************
// Funkcja enqueue() umieszcza zadaną wartość na końcu kolejki.
//**************************************************************
template <class T>
void Queue<T>::enqueue(T item)
{
  if (isFull())
    cout << "Kolejka jest pełna.\n";
  else
  {
    // Wyliczenie nowego indeksu końca kolejki
    rear = (rear + 1) % queueSize;
    // Umieszczenie nowego elementu
    queueArray[rear] = item;
    // Aktualizacja liczby elementów
    numItems++;
  }
}

//*************************************************************
// Funkcja dequeue() usuwa element z początku kolejki
// i zapisuje go w argumencie num.
//*************************************************************
template <class T>
void Queue<T>::dequeue(T &item)
{
  if (isEmpty())
    cout << "Kolejka jest pusta.\n";
  else
  {
    // Przesunięcie indeksu początku kolejki
    front = (front + 1) % queueSize;
    // Odczytanie elementu na początku kolejki
    item = queueArray[front];
    // Aktualizacja liczby elementów
    numItems--;
  }
}

//**************************************************************
// Funkcja isEmpty() zwraca wartość true, jeżeli kolejka jest pusta, lub false w przeciwnym razie.
//**************************************************************
template <class T>
bool Queue<T>::isEmpty() const
{
  bool status;

  if (numItems)
    status = false;
  else
    status = true;

  return status;
}

//**************************************************************
// Funkcja isFull() zwraca wartość true, jeżeli kolejka jest pełna, lub false w przeciwnym razie.
//**************************************************************
template <class T>
bool Queue<T>::isFull() const
{
  bool status;

  if (numItems < queueSize)
    status = false;
  else
    status = true;

  return status;
}

//**************************************************************
// Funkcja clear() resetuje indeksy front i rear oraz przypisuje zmiennej numItems wartość 0.
//**************************************************************
template <class T>
void Queue<T>::clear()
{
  front = queueSize - 1;
  rear = queueSize - 1;
  numItems = 0;
}
#endif
