// Ten program pobiera seri ocen
// i wylicza redni po odrzuceniu
// najniszej oceny.
#include <iostream>
#include <iomanip>
using namespace std;

// Prototypy funkcji
void getTestScores(double[], int);
double getTotal(const double[], int);
double getLowest(const double[], int);

int main()
{
  const int SIZE = 4;      // Wielko tablicy
  double testScores[SIZE], // Tablica z ocenami
    total,                 // Suma ocen
    lowestScore,           // Najnisza ocena
    average;               // rednia ocena

  // Ustalenie formatu wywietlanych liczb
  cout << fixed << showpoint << setprecision(1);

  // Pobranie ocen od uytkownika
  getTestScores(testScores, SIZE);

  // Wyliczenie sumy ocen
  total = getTotal(testScores, SIZE);

  // Wyszukanie najniszej oceny
  lowestScore = getLowest(testScores, SIZE);

  // Odjcie najniszej oceny od sumy ocen
  total -= lowestScore;

  // Wyliczenie redniej. Suma jest dzielona przez 3,
  // poniewa zostaa odrzucona najnisza ocena.
  average = total / (SIZE - 1);

  // Wywietlenie redniej oceny
  cout << "rednia ocena po odrzuceniu "
    << "najniszej: " << average << ".\n";

  return 0;
}

//***********************************************************
// Argumentami funkcji getTestScores() s tablica i jej wielko.
// Funkcja prosi uytkownika o podanie ocen testw
// i zapisuje je w tablicy.
//***********************************************************

void getTestScores(double scores[], int size)
{
  // Licznik ptli
  int index;

  // Pobranie ocen
  for (index = 0; index <= size - 1; index++)
  {
    cout << "Podaj ocen testu nr "
      << (index + 1) << ": ";
    cin >> scores[index];
  }
}

//*****************************************************
// Argumentami funkcji getTotal() s tablica typu double
// i jej wielko. Zwracanym wynikiem jest suma wartoci
// elementw typu double.
//*****************************************************

double getTotal(const double numbers[], int size)
{
  double total = 0; // Zmienna sumujca

  // Dodanie wartoci wszystkich elementw do zmiennej total
  for (int count = 0; count < size; count++)
    total += numbers[count];

  // Zwrcenie sumy wartoci
  return total;
}

//*****************************************************
// Argumentami funkcji getLowest() s tablica typu double
// i jej wielko. Zwracanym wynikiem jest najmniejsza
// warto w tablicy.
//*****************************************************

double getLowest(const double numbers[], int size)
{
  double lowest; // Zmienna zawierajca najmniejsz warto

  // Odczytanie wartoci pierwszego elementu
  lowest = numbers[0];

  // Przetworzenie pozostaych elementw tablicy
  // Jeeli warto elementu jest mniejsza od zmiennej lowest,
  // to element jest przypisywany tej zmiennej.
  for (int count = 1; count < size; count++)
  {
    if (numbers[count] < lowest)
      lowest = numbers[count];
  }

  // Zwrcenie najmniejszej wartoci
  return lowest;
}
