// Ten program demonstruje uycie szablonu klasy Stack.
#include <iostream>
#include <string>
#include "Stack.h"
using namespace std;

// Stae reprezentujce opcje menu
const int PUSH_CHOICE = 1,
          POP_CHOICE = 2,
          QUIT_CHOICE = 3;

// Prototypy funkcji
void menu(int &);
void getStackSize(int &);
void pushItem(Stack<string>&);
void popItem(Stack<string>&);

int main()
{
  int stackSize; // Wielko stosu
  int choice;    // Wybrana opcja menu

  // Uzyskanie wielkoci stosu
  getStackSize(stackSize);

  // Utworzenie stosu.
  Stack<string> stack(stackSize);

  do
  {
    // Uzyskanie opcji menu wybranej przez uytkownika
    menu(choice);

    // Wykonanie operacji wybranej przez uytkownika
    if (choice != QUIT_CHOICE)
    {
      switch (choice)
      {
      case PUSH_CHOICE:
        pushItem(stack);
        break;
      case POP_CHOICE:
        popItem(stack);
      }
    }
  } while (choice != QUIT_CHOICE);

  return 0;
}

//************************************************
// Funkcja getStackSize() prosi uytkownika
// o podane wielkoci stosu, ktr
// zapisuje w zmiennej podanej w argumencie.
//************************************************
void getStackSize(int &size)
{
  // Pobranie danej wielkoci stosu
  cout << "Jak duy ma by stos? ";
  cin >> size;

  // Sprawdzenie wielkoci
  while (size < 1)
  {
    cout << "Wprowad liczb 1 lub wiksz: ";
    cin >> size;
  }
}

//************************************************
// Funkcja menu() wywietla menu i pobiera opcj
// wybran przez uytkownika, ktr nastpnie
// przypisuje zmiennej wskazanej w argumencie.
//************************************************
void menu(int &choice)
{
  // Wywietlenie menu i pobranie opcji uytkownika
  cout << "\nCo chcesz zrobi?\n"
       << PUSH_CHOICE
       << " - Odoy dane na stosie\n"
       << POP_CHOICE
       << " - Zdj dane ze stosu\n"
       << QUIT_CHOICE
       << " - Zamkn program\n"
       << "Podaj opcj: ";
  cin >> choice;

  // Sprawdzenie opcji
  while (choice < PUSH_CHOICE || choice > QUIT_CHOICE)
  {
    cout << "Podaj poprawn opcj: ";
    cin >> choice;
  }
}

//************************************************
// Funkcja pushItem() odczytuje dane wprowadzone przez
// uytkownika i odkada je na stosie.
//************************************************
void pushItem(Stack<string> &stack)
{
  string item;

  // Odczytanie danych i odoenie ich na stosie
  cin.ignore();
  cout << "\nPodaj dane: ";
  getline(cin, item);
  stack.push(item);
}

//****************************************************
// Funkcja popItem() zdejmuje dane ze stosu.
//****************************************************
void popItem(Stack<string> &stack)
{
  string item = "";

  // Zdjcie danych ze stosu
  stack.pop(item);

  // Wywietlenie danych
  if (item != "")
    cout << "Zdjte dane: " << item << "\n";
}
