#include <iostream>
#include "DynIntQueue.h"
using namespace std;

//********************************************
// Ten konstruktor tworzy pust kolejk.
//********************************************

DynIntQueue::DynIntQueue()
{
  front = nullptr;
  rear = nullptr;
  numItems = 0;
}

//********************************************
// Destruktor
//********************************************

DynIntQueue::~DynIntQueue()
{
  clear();
}

//*********************************************
// Funkcja enqueue() umieszcza warto argumentu num
// na kocu kolejki.
//*********************************************

void DynIntQueue::enqueue(int num)
{
  QueueNode *newNode = nullptr;

  // Utworzenie nowego elementu i zapisanie w nim wartoci argumentu num
  newNode = new QueueNode;
  newNode->value = num;
  newNode->next = nullptr;

  // Odpowiednia modyfikacja wskanikw pocztku i koca kolejki
  if (isEmpty())
  {
    front = newNode;
    rear = newNode;
  }
  else
  {
    rear->next = newNode;
    rear = newNode;
  }

  // Aktualizacja liczby elementw
  numItems++;
}

//**********************************************
// Funkcja dequeue() usuwa element z pocztku kolejki
// i zapisuje go w argumencie num.
//**********************************************

void DynIntQueue::dequeue(int &num)
{
  QueueNode *temp = nullptr;

  if (isEmpty())
  {
    cout << "Kolejka jest pusta.\n";
  }
  else
  {
    // Zapisanie w argumencie num wartoci zawartej w pierwszym elemencie
    num = front->value;

    // Odczenie pierwszego elementu od kolejki i usunicie go
    temp = front;
    front = front->next;
    delete temp;

    // Aktualizacja liczby elementw
    numItems--;
  }
}

//*********************************************
// Funkcja isEmpty() zwraca warto true, jeeli kolejka jest pusta,
// lub false w przeciwnym razie.
//*********************************************

bool DynIntQueue::isEmpty() const
{
  bool status;

  if (numItems > 0)
    status = false;
  else
    status = true;
  return status;
}

//********************************************
// Funkcja clear() usuwa
// wszystkie elementy z kolejki.
//********************************************

void DynIntQueue::clear()
{
  int value;  // Pomocnicza zmienna wykorzystywana do usuwania elementw

  while (!isEmpty())
    dequeue(value);
}
