// Plik implementacji klasy IntArray.
#include <iostream>
#include <cstdlib> // Biblioteka wymagana przez funkcj exit()
#include "IntArray.h"
using namespace std;

//********************************************************
// Konstruktor klasy IntArray. Okrela wielko tablicy
// i przydziela jej obszar pamici.
//********************************************************
IntArray::IntArray(int s)
{
  arraySize = s;
  aptr = new int[s];
  for (int count = 0; count < arraySize; count++)
    *(aptr + count) = 0;
}

//********************************************************
// Konstruktor kopiujcy klasy IntArray
//********************************************************
IntArray::IntArray(const IntArray &obj)
{
  arraySize = obj.arraySize;
  aptr = new int[arraySize];
  for (int count = 0; count < arraySize; count++)
    *(aptr + count) = *(obj.aptr + count);
}

//********************************************************
// Destruktor klasy IntArray
//********************************************************
IntArray::~IntArray()
{
  if (arraySize > 0)
    delete[] aptr;
}

//************************************************************
// Funkcja subscriptError() wywietlajca komunikat o bdzie
// i zamykajca program gdy indeks wykracza poza zakres tablicy
//************************************************************
void IntArray::subscriptError()
{
  cout << "Bd: indeks poza zakresem.\n";
  exit(0);
}

//********************************************************
// Przeciony operator =
//********************************************************
const IntArray IntArray::operator=(const IntArray &right)
{
  if (this != &right)
  {
    delete[] aptr;
    arraySize = right.arraySize;
    aptr = new int[arraySize];
    for (int count = 0; count < arraySize; count++)
      *(aptr + count) = *(right.aptr + count);
  }
  return *this;
}

//********************************************************
// Przeciony operator []. Argumentem funkcji jest indeks
// tablicy. Funkcja zwraca referencj do elementu
// wskazywanego przez indeks.
//********************************************************
int &IntArray::operator[](const int &sub)
{
  if (sub < 0 || sub >= arraySize)
    subscriptError();
  return aptr[sub];
}
