// Plik specyfikacji klasy IntBinaryTree
#ifndef INTBINARYTREE_H
#define INTBINARYTREE_H

class IntBinaryTree
{
private:
  struct TreeNode
  {
    int value;        // Warto przechowywana w wle
    TreeNode *left;   // Wskanik do lewego wza pochodnego
    TreeNode *right;  // Wskanik do prawego wza pochodnego
  };

  TreeNode *root;     // Wskanik do wza gwnego

  // Prywatne funkcje czonkowskie
  void insert(TreeNode *&, TreeNode *&);
  void destroySubTree(TreeNode *);
  void deleteNode(int, TreeNode *&);
  void makeDeletion(TreeNode *&);
  void displayInOrder(TreeNode *) const;
  void displayPreOrder(TreeNode *) const;
  void displayPostOrder(TreeNode *) const;

public:
  // Konstruktor
  IntBinaryTree()
    { root = nullptr; }

  // Destruktor
  ~IntBinaryTree()
    { destroySubTree(root); }

  // Operacje na drzewie binarnym
  void insertNode(int);
  bool searchNode(int);
  void remove(int);

  void displayInOrder() const
    { displayInOrder(root); }

  void displayPreOrder() const
    { displayPreOrder(root); }

  void displayPostOrder() const
    { displayPostOrder(root); }
};
#endif