// Plik implementacji klasy IntQueue
#include <iostream>
#include "IntQueue.h"
using namespace std;

//***************************************************************
// Ten konstruktor klasy tworzy pust kolejk o zadanej wielkoci.
//***************************************************************

IntQueue::IntQueue(int s)
{
  queueArray = new int[s];
  queueSize = s;
  front = -1;
  rear = -1;
  numItems = 0;
}

//**************************************************************
// Konstruktor kopiujcy
//**************************************************************

IntQueue::IntQueue(const IntQueue &obj)
{
  // Utworzenie tablicy wykorzystywanej przez kolejk
  queueArray = new int[obj.queueSize];

  // Skopiowanie zmiennych czonkowskich obiektu rdowego
  queueSize = obj.queueSize;
  front = obj.front;
  rear = obj.rear;
  numItems = obj.numItems;

  // Skopiowanie tablicy wykorzystywanej przez kolejk
  for (int count = 0; count < obj.queueSize; count++)
    queueArray[count] = obj.queueArray[count];
}

//**************************************************************
// Destruktor
//**************************************************************

IntQueue::~IntQueue()
{
  delete[] queueArray;
}

//**************************************************************
// Funkcja enqueue() umieszcza zadan warto na kocu kolejki
//**************************************************************

void IntQueue::enqueue(int num)
{
  if (isFull())
    cout << "Kolejka jest pena.\n";
  else
  {
    // Wyliczenie nowego indeksu koca kolejki
    rear = (rear + 1) % queueSize;
    // Umieszczenie nowego elementu
    queueArray[rear] = num;
    // Aktualizacja liczby elementw
    numItems++;
  }
}

//**************************************************************
// Funkcja dequeue() usuwa element z pocztku kolejki
// i zapisuje go w argumencie num.
//**************************************************************

void IntQueue::dequeue(int &num)
{
  if (isEmpty())
    cout << "Kolejka jest pusta.\n";
  else
  {
    // Przesunicie indeksu pocztku kolejki
    front = (front + 1) % queueSize;
    // Odczytanie elementu na pocztku kolejki
    num = queueArray[front];
    // Aktualizacja liczby elementw
    numItems--;
  }
}

//**************************************************************
// Funkcja isEmpty() zwraca warto true, jeeli kolejka jest pusta, lub false w przeciwnym razie.
//**************************************************************

bool IntQueue::isEmpty() const
{
  bool status;

  if (numItems)
    status = false;
  else
    status = true;

  return status;
}

//**************************************************************
// Funkcja isFull() zwraca warto true, jeeli kolejka jest pena, lub false w przeciwnym razie.
//**************************************************************

bool IntQueue::isFull() const
{
  bool status;

  if (numItems < queueSize)
    status = false;
  else
    status = true;

  return status;
}

//**************************************************************
// Funkcja clear() resetuje indeksy front i rear oraz przypisuje zmiennej numItems warto 0.
//**************************************************************

void IntQueue::clear()
{
  front = queueSize - 1;
  rear = queueSize - 1;
  numItems = 0;
}