#ifndef DYNAMICSTACK_H
#define DYNAMICSTACK_H
#include <iostream>
using namespace std;

// Szablon klasy stosu
template <class T>
class DynamicStack
{
private:
  // Struktura elementu listy
  struct StackNode
  {
    T value;         // Warto przechowywania w wle
    StackNode *next; // Wskanik do nastpnego elementu
  };

  StackNode *top; // Wskanik szczytu stosu

public:
  //Konstruktor
  DynamicStack()
    { top = nullptr; }

  // Destruktor
  ~DynamicStack();

  // Operacje na stosie
  void push(T);
  void pop(T &);
  bool isEmpty();
};

//***************************************************
// Destruktor
//***************************************************
template <class T>
DynamicStack<T>::~DynamicStack()
{
  StackNode *nodePtr, *nextNode;

  // Ustawienie zmiennej nodePtr na szczycie stosu
  nodePtr = top;

  // Przegldanie listy i usuwanie kolejnych elementw
  while (nodePtr != nullptr)
  {
    nextNode = nodePtr->next;
    delete nodePtr;
    nodePtr = nextNode;
  }
}

//*************************************************************
// Funkcja push() odkadajca na stosie
// warto argumentu
//*************************************************************

template <class T>
void DynamicStack<T>::push(T item)
{
  StackNode *newNode = nullptr; // Wskanik nowego elementu

  // Utworzenie nowego elementu i zapisanie w nim wartoci argumentu num
  newNode = new StackNode;
  newNode->value = item;

  // Jeeli w licie nie ma elementw
  // newNode jest wstawiany jako pierwszy.
  if (isEmpty())
  {
    top = newNode;
    newNode->next = nullptr;
  }
  else  // W przeciwnym razie element newNode jest wstawiany przed wskanikiem top
  {
    newNode->next = top;
    top = newNode;
  }
}

//*************************************************************
// Funkcja pop() zdejmujca warto
// ze szczytu stosu i zapisujc j w zmiennej
// wskazanej w argumencie.
//*************************************************************

template <class T>
void DynamicStack<T>::pop(T &item)
{
  StackNode *temp = nullptr; // Tymczasowy wskanik

  // Sprawdzenie, czy stos nie jest pusty
  if (isEmpty())
  {
    cout << "Stos jest pusty.\n";
  }
  else // Zdjcie wartoci ze stosu
  {
    item = top->value;
    temp = top->next;
    delete top;
    top = temp;
  }
}

//*************************************************************
// Funkcja isEmpty() zwracajca warto true jeeli
// stos jest pusty, lub false w przeciwnym razie.
//*************************************************************

template <class T>
bool DynamicStack<T>::isEmpty()
{
  bool status;

  if (!top)
    status = true;
  else
    status = false;

  return status;
}
#endif
