#include <iostream>
#include "DynIntStack.h"
using namespace std;

//**************************************************
// Destruktor
// Destruktor usuwa wszystkie elementy z listy.
//**************************************************

DynIntStack::~DynIntStack()
{
  StackNode *nodePtr = nullptr, *nextNode = nullptr;

  // Ustawienie zmiennej nodePtr na szczycie stosu
  nodePtr = top;

  // Przegldanie listy i usuwanie kolejnych elementw
  while (nodePtr != nullptr)
  {
    nextNode = nodePtr->next;
    delete nodePtr;
    nodePtr = nextNode;
  }
}

//*************************************************
// Funkcja push() odkada na stosie
// warto argumentu.
//*************************************************

void DynIntStack::push(int num)
{
  StackNode *newNode = nullptr; // Wskanik nowego elementu

  // Utworzenie nowego elementu i zapisanie w nim wartoci argumentu num.
  newNode = new StackNode;
  newNode->value = num;

  // Jeeli w licie nie ma elementw,
  // newNode jest wstawiany jako pierwszy.
  if (isEmpty())
  {
    top = newNode;
    newNode->next = nullptr;
  }
  else  // W przeciwnym razie element newNode jest wstawiany przed wskanikiem top.
  {
    newNode->next = top;
    top = newNode;
  }
}

//*****************************************************
// Funkcja pop() zdejmuje warto
// ze szczytu stosu i zapisuje j w zmiennej
// wskazanej w argumencie.
//*****************************************************

void DynIntStack::pop(int &num)
{
  StackNode *temp = nullptr; // Tymczasowy wskanik

  // Sprawdzenie, czy stos nie jest pusty
  if (isEmpty())
  {
    cout << "Stos jest pusty.\n";
  }
  else // Zdjcie wartoci ze stosu
  {
    num = top->value;
    temp = top->next;
    delete top;
    top = temp;
  }
}

//*****************************************************
// Funkcja isEmpty() zwraca warto true jeeli
// stos jest pusty, lub false w przeciwnym razie.
//*****************************************************

bool DynIntStack::isEmpty()
{
  bool status;

  if (!top)
    status = true;
  else
    status = false;

  return status;
}
