﻿#ifndef SEARCHABLEVECTOR_H
#define SEARCHABLEVECTOR_H
#include "SimpleVector.h"

template <class T>
class SearchableVector : public SimpleVector<T>
{
public:
  // Domyślny konstruktor
  SearchableVector() : SimpleVector<T>()
    { }

  // Konstruktor
  SearchableVector(int size) : SimpleVector<T>(size)
    { }

  // Konstruktor kopiujący
  SearchableVector(const SearchableVector &);

  // Akcesor wyszukujący element tablicy
  int findItem(const T);
};

//*******************************************************
// Konstruktor kopiujący
//*******************************************************

template <class T>
SearchableVector<T>::SearchableVector(const SearchableVector &obj) :
  SimpleVector<T>(obj.size())
{
  for (int count = 0; count < this->size(); count++)
    this->operator[](count) = obj[count];
}

//********************************************************
// Funkcja findItem()
// Funkcja wyszukująca element tablicy. Jeżeli element zostanie znaleziony,
// funkcja zwraca jego indeks. W przeciwnym razie zwraca wartość -1.
//********************************************************

template <class T>
int SearchableVector<T>::findItem(const T item)
{
  for (int count = 0; count <= this->size(); count++)
  {
    if (SimpleVector<T>::getElementAt(count) == item)
      return count;
  }
  return -1;
}
#endif
