﻿using static System.Console;

namespace Dzien07
{
    public class AbstractionImplementation
    {
        public void Display()
        {
            BookAuthor author = new BookAuthor();
            author.GetDetail();
            BookEditor editor = new BookEditor();
            editor.GetDetail();
            BookReviewer reviewer = new BookReviewer();
            reviewer.GetDetail();
        }
    }

    public abstract class Team
    {
        public abstract void GetDetail();
    }

    public class BookAuthor : Team
    {
        public override void GetDetail() => Display();

        private void Display()
        {
            WriteLine("Informacje o autorze.");
            Write("Podaj personalia autora: ");
            var name = ReadLine();
            WriteLine($"Autorem książki jest: {name}.");
        }
    }

    public class BookEditor : Team
    {
        public override void GetDetail() => Display();

        private void Display()
        {
            WriteLine("Informacje o redaktorze.");
            Write("Podaj personalia redaktora: ");
            var name = ReadLine();
            WriteLine($"Redaktorem książki jest: {name}.");
        }
    }

    public class BookReviewer : Team
    {
        public override void GetDetail() => Display();

        private void Display()
        {
            WriteLine("Informacje o recenzencie.");
            Write("Podaj personalia recenzenta: ");
            var name = ReadLine();
            WriteLine($"Recenzentem książki jest: {name}.");
        }
    }
}