/*
 * Copyright 2013 Oracle and/or its affiliates.
 * All rights reserved.  You may not modify, use,
 * reproduce, or distribute this software except in
 * compliance with  the terms of the License at:
 * http://developers.sun.com/license/berkeley_license.html
 */


package com.forest.web;

import com.forest.entity.Groups;
import com.forest.entity.Person;
import com.forest.qualifiers.LoggedIn;
import com.forest.web.util.JsfUtil;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Produces;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;


/**
 *
 * @author markito
 */
@Named(value = "userController")
@SessionScoped
public class UserController implements Serializable {
    private static final String BUNDLE = "/Bundle";
    private static final long serialVersionUID = -8851462237612818158L;
    @Inject
    CustomerController customerController;
    Person user;
    @EJB
    private com.forest.ejb.UserBean ejbFacade;
    private String password;
    private String username;

    /**
     * Creates a new instance of Login
     */
    public UserController() {
    }

    /**
     * Login method based on
     * <code>HttpServletRequest</code> and security realm
     */
    public String login() {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletRequest request = (HttpServletRequest) context.getExternalContext()
                                                                 .getRequest();
        String result;

        try {
            request.login(
                this.getUsername(),
                this.getPassword());

            JsfUtil.addSuccessMessage(
                    JsfUtil.getStringFromBundle(BUNDLE, "Login_Success"));

            this.user = ejbFacade.getUserByEmail(getUsername());
            this.getAuthenticatedUser();

            if (isAdmin()) {
                result = "/admin/index";
            } else {
                result = "/index";
            }
        } catch (ServletException ex) {
            Logger.getLogger(UserController.class.getName())
                  .log(Level.SEVERE, null, ex);
            JsfUtil.addErrorMessage(
                    JsfUtil.getStringFromBundle(BUNDLE, "Login_Failed"));

            result = "login";
        }

        return result;
    }

    public String logout() {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletRequest request = (HttpServletRequest) context.getExternalContext()
                                                                 .getRequest();

        try {
            this.user = null;

            request.logout();

            // clear the session
            ((HttpSession) context.getExternalContext()
                                  .getSession(false)).invalidate();

            JsfUtil.addSuccessMessage(
                    JsfUtil.getStringFromBundle(BUNDLE, "Logout_Success"));
        } catch (ServletException ex) {
            Logger.getLogger(UserController.class.getName())
                  .log(Level.SEVERE, null, ex);
            JsfUtil.addErrorMessage(
                    JsfUtil.getStringFromBundle(BUNDLE, "Logout_Failed"));
        } finally {
            return "/index";
        }
    }

    /**
     * @return the ejbFacade
     */
    public com.forest.ejb.UserBean getEjbFacade() {
        return ejbFacade;
    }

    @Produces
    @LoggedIn
    public Person getAuthenticatedUser() {
        return user;
    }

    public boolean isLogged() {
        return (getUser() == null) ? false : true;
    }

    public boolean isAdmin() {
        for (Groups g : user.getGroupsList()) {
            if (g.getName()
                     .equals("ADMINS")) {
                return true;
            }
        }

        return false;
    }

    public String goAdmin() {
        if (isAdmin()) {
            return "/admin/index";
        } else {
            return "index";
        }
    }

    /**
     * @return the username
     */
    public String getUsername() {
        return username;
    }

    /**
     * @param username the username to set
     */
    public void setUsername(String username) {
        this.username = username;
    }

    /**
     * @return the password
     */
    public String getPassword() {
        return password;
    }

    /**
     * @param password the password to set
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * @return the user
     */
    public Person getUser() {
        return user;
    }
}
