/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import java.util.Random;
import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;

public class TransactedExample {
    @Resource(lookup="jms/ConnectionFactory")
    private static ConnectionFactory connectionFactory;
    @Resource(lookup="jms/AQueue")
    private static Queue vendorOrderQueue;
    @Resource(lookup="jms/BQueue")
    private static Queue retailerConfirmQueue;
    @Resource(lookup="jms/CQueue")
    private static Queue vendorConfirmQueue;
    @Resource(lookup="jms/OTopic")
    private static Topic supplierOrderTopic;

    public static void run_threads(int quantity) {
        Retailer r = new Retailer(quantity);
        Vendor v = new Vendor();
        GenericSupplier ms = new GenericSupplier("Procesor");
        GenericSupplier ss = new GenericSupplier("Dysk twardy");
        ms.start();
        ss.start();
        r.start();
        v.start();
        try {
            ms.join();
            ss.join();
            r.join();
            v.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        TransactedExample te = new TransactedExample();
        int quantity = 0;
        if (args.length != 1) {
            System.out.println("Program przyjmuje argument liczbowy.");
            System.err.println("Program zak\u0142ada istnienie trzech kolejek nazwanych jms/AQueue, jms/BQueue i jms/CQueue oraz jednego tematu jms/OTopic");
            System.exit(1);
        }
        quantity = new Integer(args[0]);
        System.out.println("Liczba zamawianych sztuk: " + quantity);
        if (quantity > 0) {
            TransactedExample.run_threads(quantity);
            System.exit(0);
        } else {
            System.out.println("Liczba sztuk musi by\u0107 dodatnia i niezerowa");
            System.exit(1);
        }
    }

    public static class VendorMessageListener
    implements MessageListener {
        final SampleUtilities.DoneLatch monitor = new SampleUtilities.DoneLatch();
        int numSuppliers;
        private final Session session;

        public VendorMessageListener(Session s, int numSuppliers) {
            this.session = s;
            this.numSuppliers = numSuppliers;
        }

        public void onMessage(Message message) {
            if (!(message instanceof MapMessage)) {
                if (Order.outstandingOrders() == 0) {
                    --this.numSuppliers;
                    if (this.numSuppliers == 0) {
                        this.monitor.allDone();
                    }
                }
                try {
                    this.session.commit();
                }
                catch (JMSException je) {
                    // empty catch block
                }
                return;
            }
            int orderNumber = -1;
            try {
                MapMessage component = (MapMessage)message;
                orderNumber = component.getInt("VendorOrderNumber");
                Order order = Order.getOrder(orderNumber).processSubOrder(component);
                this.session.commit();
                if (!order.isPending()) {
                    System.out.println("Hurtownia: Zako\u0144czono przetwarzanie zam\u00f3wienia " + order.orderNumber);
                    Queue replyQueue = (Queue)order.order.getJMSReplyTo();
                    MessageProducer producer = this.session.createProducer((Destination)replyQueue);
                    MapMessage retailerConfirmMessage = this.session.createMapMessage();
                    if (order.isFulfilled()) {
                        retailerConfirmMessage.setBoolean("OrderAccepted", true);
                        System.out.println("Hurtownia: wys\u0142ano " + order.quantity + " komputer\u00f3w");
                    } else if (order.isCancelled()) {
                        retailerConfirmMessage.setBoolean("OrderAccepted", false);
                        System.out.println("Hurtownia: nie uda\u0142o si\u0119 wys\u0142a\u0107 " + order.quantity + " komputer\u00f3w");
                    }
                    producer.send((Message)retailerConfirmMessage);
                    this.session.commit();
                    System.out.println("  Vendor: zatwierdzono transakcj\u0119 numer 2");
                }
            }
            catch (JMSException je) {
                je.printStackTrace();
                try {
                    this.session.rollback();
                }
                catch (JMSException je2) {}
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.session.rollback();
                }
                catch (JMSException je2) {
                    // empty catch block
                }
            }
        }
    }

    public static class Vendor
    extends Thread {
        Random rgen = new Random();
        int throwException = 1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection connection = null;
            Session session = null;
            Session asyncSession = null;
            MessageConsumer vendorOrderReceiver = null;
            MessageProducer supplierOrderProducer = null;
            MapMessage orderMessage = null;
            MessageConsumer vendorConfirmReceiver = null;
            VendorMessageListener listener = null;
            Message inMessage = null;
            MapMessage vendorOrderMessage = null;
            Message endOfMessageStream = null;
            Order order = null;
            int quantity = 0;
            try {
                connection = connectionFactory.createConnection();
                session = connection.createSession(true, 0);
                asyncSession = connection.createSession(true, 0);
            }
            catch (Exception e) {
                System.err.println("Problem z po\u0142\u0105czeniem: " + e.toString());
                System.err.println("Program zak\u0142ada istnienie trzech kolejek nazwanych jms/AQueue, jms/BQueue i jms/CQueue oraz jednego tematu jms/OTopic");
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException ee) {
                        // empty catch block
                    }
                }
                System.exit(1);
            }
            try {
                vendorOrderReceiver = session.createConsumer((Destination)vendorOrderQueue);
                supplierOrderProducer = session.createProducer((Destination)supplierOrderTopic);
                orderMessage = session.createMapMessage();
                vendorConfirmReceiver = asyncSession.createConsumer((Destination)vendorConfirmQueue);
                listener = new VendorMessageListener(asyncSession, 2);
                vendorConfirmReceiver.setMessageListener((MessageListener)listener);
                connection.start();
                block17: while (true) {
                    try {
                        while (true) {
                            if (!((inMessage = vendorOrderReceiver.receive()) instanceof MapMessage)) {
                                endOfMessageStream = session.createMessage();
                                endOfMessageStream.setJMSReplyTo((Destination)vendorConfirmQueue);
                                supplierOrderProducer.send(endOfMessageStream);
                                session.commit();
                                break block17;
                            }
                            vendorOrderMessage = (MapMessage)inMessage;
                            if (this.rgen.nextInt(3) == this.throwException) {
                                throw new JMSException("Symulacja wyj\u0105tku wsp\u00f3\u0142bie\u017cnego dost\u0119pu do bazy danych");
                            }
                            order = new Order(vendorOrderMessage);
                            orderMessage.setInt("VendorOrderNumber", order.orderNumber);
                            orderMessage.setJMSReplyTo((Destination)vendorConfirmQueue);
                            quantity = vendorOrderMessage.getInt("Quantity");
                            System.out.println("Hurtownia: sprzedawca zam\u00f3wi\u0142 " + quantity + " sztuk " + vendorOrderMessage.getString("Item"));
                            orderMessage.setString("Item", "");
                            orderMessage.setInt("Quantity", quantity);
                            supplierOrderProducer.send((Message)orderMessage);
                            System.out.println("Hurtownia: zam\u00f3wiono " + quantity + " procesor\u00f3w i dysk\u00f3w twardnych");
                            session.commit();
                            System.out.println("  Hurtownia: zatwierdzona transakcja numer 1");
                        }
                    }
                    catch (JMSException e) {
                        System.err.println("Hurtownia: Wyj\u0105tek JMSException: " + e.toString());
                        e.printStackTrace();
                        session.rollback();
                        System.err.println("  Hurtownia: wycofana transakcja numer 1");
                        continue;
                    }
                    break;
                }
                listener.monitor.waitTillDone();
            }
            catch (JMSException e) {
                System.err.println("Hurtownia: wystapi\u0142 wyj\u0105tek: " + e.toString());
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException e) {}
                }
            }
        }
    }

    public static class Retailer
    extends Thread {
        int quantity = 0;

        public Retailer(int q) {
            this.quantity = q;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection connection = null;
            Session session = null;
            MessageProducer producer = null;
            MapMessage outMessage = null;
            MessageConsumer orderConfirmReceiver = null;
            MapMessage inMessage = null;
            try {
                connection = connectionFactory.createConnection();
                session = connection.createSession(false, 1);
            }
            catch (Exception e) {
                System.err.println("Problem z po\u0142\u0105czeniem: " + e.toString());
                System.err.println("Program zak\u0142ada istnienie trzech kolejek nazwanych jms/AQueue, jms/BQueue i jms/CQueue oraz jednego tematu jms/OTopic");
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException ee) {
                        // empty catch block
                    }
                }
                System.exit(1);
            }
            try {
                producer = session.createProducer((Destination)vendorOrderQueue);
                outMessage = session.createMapMessage();
                outMessage.setString("Item", "Komputery");
                outMessage.setInt("Quantity", this.quantity);
                outMessage.setJMSReplyTo((Destination)retailerConfirmQueue);
                producer.send((Message)outMessage);
                System.out.println("Sprzedawca detaliczny: zam\u00f3wienie na " + this.quantity + " komputer\u00f3w");
                orderConfirmReceiver = session.createConsumer((Destination)retailerConfirmQueue);
                connection.start();
                inMessage = (MapMessage)orderConfirmReceiver.receive();
                if (inMessage.getBoolean("OrderAccepted")) {
                    System.out.println("Sprzedawca detaliczny: zam\u00f3wienie wype\u0142nione");
                } else {
                    System.out.println("Sprzedawca detaliczny: zam\u00f3wienie nie jest wype\u0142nione");
                }
                System.out.println("Sprzedawca detaliczny: umieszczenie kolejnego zam\u00f3wienia");
                outMessage.setInt("Quantity", this.quantity * 2);
                producer.send((Message)outMessage);
                System.out.println("Sprzedawca detaliczny: zam\u00f3wiono " + outMessage.getInt("Quantity") + " komputer\u00f3w");
                inMessage = (MapMessage)orderConfirmReceiver.receive();
                if (inMessage.getBoolean("OrderAccepted")) {
                    System.out.println("Sprzedawca detaliczny: zam\u00f3wienie wype\u0142nione");
                } else {
                    System.out.println("Sprzedawca detaliczny: zam\u00f3wienie nie jest wype\u0142nione");
                }
                producer.send(session.createMessage());
            }
            catch (Exception e) {
                System.err.println("Sprzedawca detaliczny: wyst\u0105pi\u0142 wyj\u0105tek: " + e.toString());
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException e) {}
                }
            }
        }
    }

    public static class Order {
        private static Hashtable<Integer, Order> pendingOrders = new Hashtable();
        private static int nextOrderNumber = 1;
        private static final int PENDING_STATUS = 1;
        private static final int CANCELLED_STATUS = 2;
        private static final int FULFILLED_STATUS = 3;
        public MapMessage cpu = null;
        public final MapMessage order;
        public MapMessage storage = null;
        public final int orderNumber = Order.getNextOrderNumber();
        public int quantity;
        int status;

        public Order(MapMessage order) {
            this.order = order;
            try {
                this.quantity = order.getInt("Quantity");
            }
            catch (JMSException je) {
                System.err.println("Nieoczekiwany b\u0142\u0105d. Komunikat nie zawiera Quantity");
                this.quantity = 0;
            }
            this.status = 1;
            pendingOrders.put(new Integer(this.orderNumber), this);
        }

        private static int getNextOrderNumber() {
            int result = nextOrderNumber++;
            return result;
        }

        public static int outstandingOrders() {
            return pendingOrders.size();
        }

        public static Order getOrder(int orderNumber) {
            return pendingOrders.get(new Integer(orderNumber));
        }

        public Order processSubOrder(MapMessage component) {
            String itemName = null;
            try {
                itemName = component.getString("Item");
            }
            catch (JMSException je) {
                System.err.println("Nieoczekiwany b\u0142\u0105d. Komunikat nie zawiera Item");
            }
            if (itemName.compareTo("Procesor") == 0) {
                this.cpu = component;
            } else if (itemName.compareTo("Dysk twardy") == 0) {
                this.storage = component;
            }
            if (this.cpu != null && this.storage != null) {
                try {
                    this.status = this.quantity > this.cpu.getInt("Quantity") ? 2 : (this.quantity > this.storage.getInt("Quantity") ? 2 : 3);
                }
                catch (JMSException je) {
                    System.err.println("Nieoczekiwany wyj\u0105tek: " + je.toString());
                    this.status = 2;
                }
                pendingOrders.remove(new Integer(this.orderNumber));
            }
            return this;
        }

        public boolean isPending() {
            return this.status == 1;
        }

        public boolean isCancelled() {
            return this.status == 2;
        }

        public boolean isFulfilled() {
            return this.status == 3;
        }
    }

    public static class GenericSupplier
    extends Thread {
        final String PRODUCT_NAME;
        boolean ready = false;
        int quantity = 0;

        public GenericSupplier(String itemName) {
            this.PRODUCT_NAME = itemName;
        }

        void waitForTopicConsumer() {
            while (!this.ready) {
            }
        }

        public int checkInventory() {
            Random rgen = new Random();
            return rgen.nextInt(this.quantity * 5);
        }

        @Override
        public void run() {
            Connection connection = null;
            Session session = null;
            MessageConsumer receiver = null;
            Message inMessage = null;
            MapMessage orderMessage = null;
            MapMessage outMessage = null;
            try {
                connection = connectionFactory.createConnection();
                session = connection.createSession(true, 0);
            }
            catch (Exception e) {
                System.err.println("Problem z po\u0142\u0105czeniem: " + e.toString());
                System.err.println("Program zak\u0142ada istnienie trzech kolejek nazwanych jms/AQueue, jms/BQueue i jms/CQueue oraz jednego tematu jms/OTopic");
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException ee) {
                        // empty catch block
                    }
                }
                System.exit(1);
            }
            try {
                receiver = session.createConsumer((Destination)supplierOrderTopic);
                connection.start();
            }
            catch (JMSException je) {
                // empty catch block
            }
            this.ready = true;
            block10: while (true) {
                try {
                    while (true) {
                        MessageProducer producer;
                        if (!((inMessage = receiver.receive()) instanceof MapMessage)) {
                            producer = session.createProducer(inMessage.getJMSReplyTo());
                            producer.send(session.createMessage());
                            session.commit();
                            break block10;
                        }
                        orderMessage = (MapMessage)inMessage;
                        this.quantity = orderMessage.getInt("Quantity");
                        System.out.println(this.PRODUCT_NAME + " - dostawca: hurtownia zam\u00f3wi\u0142a " + this.quantity + " sztuk produktu " + this.PRODUCT_NAME);
                        producer = session.createProducer((Destination)((Queue)orderMessage.getJMSReplyTo()));
                        outMessage = session.createMapMessage();
                        outMessage.setInt("VendorOrderNumber", orderMessage.getInt("VendorOrderNumber"));
                        outMessage.setString("Item", this.PRODUCT_NAME);
                        int numAvailable = this.checkInventory();
                        if (numAvailable >= this.quantity) {
                            outMessage.setInt("Quantity", this.quantity);
                        } else {
                            outMessage.setInt("Quantity", numAvailable);
                        }
                        producer.send((Message)outMessage);
                        System.out.println(this.PRODUCT_NAME + " - dostawca: wysy\u0142ka " + outMessage.getInt("Quantity") + " sztuk produktu " + outMessage.getString("Item"));
                        session.commit();
                        System.out.println("  " + this.PRODUCT_NAME + " - dostawca: transakcja zatwierdzona");
                    }
                }
                catch (Exception e) {
                    System.err.println(this.PRODUCT_NAME + " - dostawca: wystapi\u0142 wyj\u0105tek: " + e.toString());
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    // empty catch block
                }
            }
        }
    }
}

