/*
 * Decompiled with CFR 0.152.
 */
package eb;

import eb.SetupOffice;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@MessageDriven(mappedName="jms/Topic", activationConfig={@ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge"), @ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientId", propertyValue="EquipmentMDB"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="EquipmentMDB")})
public class EquipmentMDB
implements MessageListener {
    static final Logger logger = Logger.getLogger("EquipmentMDB");
    @Resource
    public MessageDrivenContext mdc;
    @PersistenceContext
    EntityManager em;
    @Resource(lookup="jms/ConnectionFactory")
    private ConnectionFactory connectionFactory;
    private Random processingTime = new Random();

    public void onMessage(Message inMessage) {
        try {
            if (inMessage instanceof MapMessage) {
                MapMessage msg = (MapMessage)inMessage;
                String key = msg.getString("HireID");
                String name = msg.getString("Name");
                String position = msg.getString("Position");
                logger.log(Level.INFO, "EquipmentMDB.onMessage: Otrzymano komunikat dla pracownika o identyfikatorze {0}", key);
                String equipmentList = position.equals("programista") ? "komputer stacjonarny" : (position.equals("starszy programista") ? "laptop" : (position.equals("kierownik") ? "PDA" : (position.equals("dyrektor") ? "telefon z Jav\u0105" : "pa\u0142ka")));
                Thread.sleep(this.processingTime.nextInt(10) * 1000);
                this.compose(key, name, equipmentList, (Message)msg);
            } else {
                logger.log(Level.WARNING, "EquipmentMDB.onMessage:Komunikat niew\u0142a\u015bciwego typu: {0}", inMessage.getClass().getName());
            }
        }
        catch (JMSException e) {
            logger.log(Level.SEVERE, "EquipmentMDB.onMessage: Wyj\u0105tek JMSException: {0}", e.toString());
            this.mdc.setRollbackOnly();
        }
        catch (Throwable te) {
            logger.log(Level.SEVERE, "EquipmentMDB.onMessage: Wyj\u0105tek: {0}", te.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compose(String key, String name, String equipmentList, Message msg) {
        boolean num = false;
        SetupOffice so = null;
        Connection connection = null;
        boolean done = false;
        try {
            so = (SetupOffice)this.em.find(SetupOffice.class, (Object)key);
            if (so != null) {
                logger.log(Level.INFO, "EquipmentMDB.compose: Znaleziono wsp\u00f3ln\u0105 encj\u0119 dla pracownika o identyfikatorze {0}", key);
            }
        }
        catch (IllegalArgumentException iae) {
            logger.warning("EquipmentMDB.compose: Nie znaleziono wsp\u00f3lnej encji");
        }
        catch (Exception e) {
            logger.severe("EquipmentMDB.compose: em.find zawiod\u0142o bez zg\u0142oszenia IllegalArgumentException");
        }
        if (so == null) {
            try {
                logger.log(Level.INFO, "EquipmentMDB.compose: Tworzenie wsp\u00f3lnej encji dla pracownika o identyfikatorze {0}", key);
                so = new SetupOffice(key, name);
                this.em.persist((Object)so);
            }
            catch (Exception e) {
                logger.warning("EquipmentMDB.compose: Nie mo\u017cna by\u0142o utworzy\u0107 wsp\u00f3lnej encji");
                this.mdc.setRollbackOnly();
            }
        }
        if (so != null) {
            try {
                done = so.doEquipmentList(equipmentList);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "EquipmentMDB.compose: Nie uzyskano sprz\u0119tu dla pracownika o identyfikatorze {0}", key);
                this.mdc.setRollbackOnly();
            }
        }
        if (done) {
            try {
                connection = this.connectionFactory.createConnection();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "EquipmentMDB.compose: Nie uzyskano po\u0142\u0105czenia do dostawcy JMS: {0}", ex.toString());
            }
            try {
                Destination replyDest = msg.getJMSReplyTo();
                String replyCorrelationMsgId = msg.getJMSMessageID();
                Session session = connection.createSession(true, 0);
                MessageProducer producer = session.createProducer(replyDest);
                MapMessage replyMsg = this.createReplyMsg(so, session, replyCorrelationMsgId);
                producer.send((Message)replyMsg);
                logger.log(Level.INFO, "EquipmentMDB.compose: Wys\u0142ano komunikat odpowiedzi dla pracownika o identyfikatorze {0}", so.getEmployeeId());
            }
            catch (JMSException je) {
                logger.log(Level.SEVERE, "EquipmentMDB.compose: Wyj\u0105tek JMSException: {0}", je.toString());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "EquipmentMDB.compose: Wyj\u0105tek: {0}", e.toString());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException je) {
                        logger.log(Level.SEVERE, "EquipmentMDB.compose: Wyj\u0105tek JMSException: {0}", je.toString());
                    }
                }
            }
            logger.log(Level.INFO, "EquipmentMDB.compose: USUWANIE encji SetupOffice - employeeId={0}, Name={1}", new Object[]{so.getEmployeeId(), so.getEmployeeName()});
            this.em.remove((Object)so);
        }
    }

    private MapMessage createReplyMsg(SetupOffice so, Session session, String msgId) throws JMSException {
        MapMessage replyMsg = session.createMapMessage();
        replyMsg.setString("employeeId", so.getEmployeeId());
        replyMsg.setString("employeeName", so.getEmployeeName());
        replyMsg.setString("equipmentList", so.getEquipmentList());
        replyMsg.setInt("officeNumber", so.getOfficeNumber());
        replyMsg.setJMSCorrelationID(msgId);
        return replyMsg;
    }
}

