/*
 * Decompiled with CFR 0.152.
 */
import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class Producer {
    @Resource(lookup="jms/ConnectionFactory")
    private static ConnectionFactory connectionFactory;
    @Resource(lookup="jms/Queue")
    private static Queue queue;
    @Resource(lookup="jms/Topic")
    private static Topic topic;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Connection connection = null;
        if (args.length < 1 || args.length > 2) {
            System.err.println("Program przyjmuje jeden lub dwa argumenty: <typ-celu> [<liczba-komunikat\u00f3w>]");
            System.exit(1);
        }
        String destType = args[0];
        System.out.println("Typ celu to " + destType);
        if (!destType.equals("kolejka") && !destType.equals("temat")) {
            System.err.println("Argument musi by\u0107 typu \"kolejka\" lub \"temat\"");
            System.exit(1);
        }
        int NUM_MSGS = args.length == 2 ? new Integer(args[1]) : 1;
        Object dest = null;
        try {
            dest = destType.equals("kolejka") ? queue : topic;
        }
        catch (Exception e) {
            System.err.println("B\u0142\u0105d wysy\u0142ania: " + e.toString());
            e.printStackTrace();
            System.exit(1);
        }
        try {
            connection = connectionFactory.createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)dest);
            TextMessage message = session.createTextMessage();
            for (int i = 0; i < NUM_MSGS; ++i) {
                message.setText("Oto " + (i + 1) + ". komunikat od producenta");
                System.out.println("Wysy\u0142anie komunikatu: " + message.getText());
                producer.send((Message)message);
            }
            producer.send(session.createMessage());
        }
        catch (JMSException e) {
            System.err.println("Wyst\u0105pi\u0142 wyj\u0105tek: " + e.toString());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {}
            }
        }
    }
}

