// Plik: Employee.cpp
// Definicje funkcji składowych klasy Employee
// Uwaga: dla funkcji wirtualnej nie została zdefiniowana żadna definicja
#include <iostream>
#include "Employee.h" // Definicja klasy Employee
using namespace std;

// Konstruktor
Employee::Employee( const string &first, const string &last,
   const string &ssn )
   : firstName( first ), lastName( last ), socialSecurityNumber( ssn )
{
   // Pusta definicja
} // Koniec konstruktora klasy Employee

// Zdefiniowanie imienia
void Employee::setFirstName( const string &first ) 
{ 
   firstName = first;  
} // Koniec funkcji setFirstName()

// Pobranie imienia
string Employee::getFirstName() const 
{ 
   return firstName;  
} // Koniec funkcji getFirstName()

// Zdefiniowanie nazwiska
void Employee::setLastName( const string &last )
{
   lastName = last;   
} // Koniec funkcji setLastName()

// Pobranie nazwiska
string Employee::getLastName() const
{
   return lastName;   
} // Koniec funkcji getLastName()

// Zdefiniowanie numeru ubezpieczenia społecznego
void Employee::setSocialSecurityNumber( const string &ssn )
{
   socialSecurityNumber = ssn; // Ta wartość powinna zostać zweryfikowana
} // Koniec funkcji setSocialSecurityNumber()

// Pobranie numeru ubezpieczenia społecznego
string Employee::getSocialSecurityNumber() const
{
   return socialSecurityNumber;   
} // Koniec funkcji getSocialSecurityNumber()

// Wyświetlenie informacji przechowywanych w obiekcie Employee (to funkcja wirtualna, ale nie czysta funkcja wirtualna)
void Employee::print() const
{ 
   cout << getFirstName() << ' ' << getLastName() 
      << "\nNumer ubezpieczenia społecznego: " << getSocialSecurityNumber(); 
} // Koniec funkcji print()
